/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.components;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import reliquary.client.gui.components.Box;
import reliquary.client.gui.components.Component;
import reliquary.client.gui.components.ItemStackPane;
import reliquary.client.gui.components.TextPane;
import reliquary.reference.Colors;

public class ItemStackCountPane
extends Component {
    private final ItemStackPane itemStackPane;
    private final TextPane countPane;
    private final Box box;

    public ItemStackCountPane(ItemStack itemStack, int count) {
        this(itemStack, count, Colors.get("FFFFFF"));
    }

    public ItemStackCountPane(ItemStack itemStack, int count, int textColor) {
        this(Box.Layout.HORIZONTAL, itemStack, count, textColor);
    }

    public ItemStackCountPane(Box.Layout layout, ItemStack itemStack, int count, int textColor) {
        this.countPane = new TextPane(String.valueOf(count), textColor);
        this.itemStackPane = new ItemStackPane(itemStack);
        this.box = new Box(layout, Box.Alignment.MIDDLE, this.itemStackPane, this.countPane);
    }

    public void setCount(int count) {
        this.countPane.setText(String.valueOf(count));
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStackPane.setItemStack(itemStack);
    }

    @Override
    public int getPadding() {
        return this.box.getPadding();
    }

    @Override
    public int getHeightInternal() {
        return this.box.getHeightInternal();
    }

    @Override
    public int getWidthInternal() {
        return this.box.getWidthInternal();
    }

    @Override
    public void renderInternal(GuiGraphics guiGraphics, int x, int y) {
        this.box.renderInternal(guiGraphics, x, y);
    }
}

