/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ColorParticleOption;

public class CauldronBubbleParticle
extends TextureSheetParticle {
    private static final int FRAMES_OF_EACH_POP_STAGE = 2;
    private static final int POP_STAGES = 3;
    private final SpriteSet spriteSet;

    private CauldronBubbleParticle(ClientLevel level, ColorParticleOption particleOption, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.spriteSet = spriteSet;
        this.setSize(0.02f, 0.02f);
        this.quadSize = 0.5f + (level.random.nextFloat() - 0.5f) * 0.4f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.rCol = particleOption.getRed();
        this.gCol = particleOption.getGreen();
        this.bCol = particleOption.getBlue();
        this.lifetime = 20;
        this.age = 0;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.setAlpha((float)this.age / (float)this.lifetime);
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.spriteSet);
        }
    }

    public float getQuadSize(float partialTicks) {
        return 0.1f * this.quadSize * (1.0f + (float)this.age / 20.0f);
    }

    public void setSpriteFromAge(SpriteSet animatedSprite) {
        int ageFromDeath = this.lifetime - this.age;
        if (ageFromDeath <= 6) {
            this.setSprite(animatedSprite.get(4 - Math.max(ageFromDeath / 2, 1), 3));
        } else {
            this.setSprite(animatedSprite.get(0, this.lifetime));
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Provider
    implements ParticleProvider<ColorParticleOption> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(ColorParticleOption particleData, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CauldronBubbleParticle particle = new CauldronBubbleParticle(level, particleData, x, y, z, this.spriteSet);
            particle.setSprite(this.spriteSet.get(particle.age, particle.lifetime));
            return particle;
        }
    }
}

