/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.render;

import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.ArrowRenderState;
import net.minecraft.client.renderer.entity.state.TippableArrowRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.projectile.AbstractArrow;
import reliquary.entity.TippedArrow;

public class TippedArrowRenderer
extends ArrowRenderer<TippedArrow, TippableArrowRenderState> {
    private static final ResourceLocation RES_ARROW = ResourceLocation.parse((String)"textures/entity/projectiles/arrow.png");
    private static final ResourceLocation RES_TIPPED_ARROW = ResourceLocation.parse((String)"textures/entity/projectiles/tipped_arrow.png");

    public TippedArrowRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public TippableArrowRenderState createRenderState() {
        return new TippableArrowRenderState();
    }

    public void extractRenderState(TippedArrow arrow, TippableArrowRenderState renderState, float partialTick) {
        super.extractRenderState((AbstractArrow)arrow, (ArrowRenderState)renderState, partialTick);
        renderState.isTipped = arrow.getColor() > 0;
    }

    protected ResourceLocation getTextureLocation(TippableArrowRenderState renderState) {
        return renderState.isTipped ? RES_TIPPED_ARROW : RES_ARROW;
    }
}

