/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.curios;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.init.ModItems;
import reliquary.item.FortuneCoinToggler;
import reliquary.network.FortuneCoinTogglePressedPayload;
import top.theillusivec4.curios.api.CuriosApi;

class CuriosFortuneCoinToggler
extends FortuneCoinToggler {
    CuriosFortuneCoinToggler() {
    }

    @Override
    public boolean findAndToggle() {
        if (super.findAndToggle()) {
            return true;
        }
        return CuriosApi.getCuriosInventory((LivingEntity)Minecraft.getInstance().player).map(handler -> {
            AtomicBoolean result = new AtomicBoolean(false);
            handler.getCurios().forEach((identifier, stackHandler) -> {
                for (int slot = 0; slot < stackHandler.getSlots(); ++slot) {
                    ItemStack baubleStack = stackHandler.getStacks().getStackInSlot(slot);
                    if (baubleStack.getItem() != ModItems.FORTUNE_COIN.get()) continue;
                    ModItems.FORTUNE_COIN.get().toggle(baubleStack);
                    stackHandler.getStacks().setStackInSlot(slot, baubleStack);
                    PacketDistributor.sendToServer((CustomPacketPayload)new FortuneCoinTogglePressedPayload(FortuneCoinTogglePressedPayload.InventoryType.CURIOS, slot, (String)identifier), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    result.set(true);
                    return;
                }
            });
            return result.get();
        }).orElse(false);
    }

    public void registerSelf() {
        FortuneCoinToggler.setCoinToggler(this);
    }
}

