/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.library.plugins.vanilla.crafting.JeiShapedRecipe;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import reliquary.Reliquary;
import reliquary.crafting.MobCharmRecipe;
import reliquary.init.ModItems;
import reliquary.item.MobCharmFragmentItem;
import reliquary.item.MobCharmRegistry;

public class MobCharmRecipeMaker {
    private MobCharmRecipeMaker() {
    }

    public static List<RecipeHolder<CraftingRecipe>> getRecipes() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        MobCharmRecipe.REGISTERED_RECIPES.forEach(baseRecipe -> MobCharmRecipeMaker.addMobCharmRecipes(recipes, baseRecipe));
        return recipes;
    }

    private static void addMobCharmRecipes(List<RecipeHolder<CraftingRecipe>> recipes, MobCharmRecipe baseRecipe) {
        for (ResourceLocation regName : MobCharmRegistry.getRegisteredNames()) {
            ArrayList slotDisplays = new ArrayList();
            ItemStack output = ModItems.MOB_CHARM.get().getStackFor(regName);
            baseRecipe.getIngredients().forEach(i -> i.ifPresentOrElse(ingredient -> {
                if (ingredient.getValues().stream().anyMatch(holder -> holder.value() instanceof MobCharmFragmentItem)) {
                    ArrayList slotDisplayList = new ArrayList();
                    ingredient.getValues().forEach(holder -> {
                        if (holder.value() instanceof MobCharmFragmentItem) {
                            ItemStack itemStack = ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(regName);
                            slotDisplayList.add(new SlotDisplay.ItemStackSlotDisplay(itemStack));
                        } else {
                            slotDisplayList.add(new SlotDisplay.ItemSlotDisplay((Item)holder.value()));
                        }
                    });
                    slotDisplays.add(new SlotDisplay.Composite(slotDisplayList));
                } else {
                    slotDisplays.add(ingredient.display());
                }
            }, () -> slotDisplays.add(SlotDisplay.Empty.INSTANCE)));
            ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, baseRecipe.getIngredients(), Optional.empty());
            ResourceKey id = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Reliquary.getRL("mob_charm_" + regName.toString().replace(':', '_')));
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(id, (Recipe)new JeiShapedRecipe("reliquary.mob_charm", CraftingBookCategory.MISC, pattern, slotDisplays, (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(output))));
        }
    }
}

