/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.lingering;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import reliquary.init.ModItems;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionMap;

public class ArrowShotRecipeMaker {
    private ArrowShotRecipeMaker() {
    }

    public static List<RecipeHolder<CraftingRecipe>> getRecipes(IJeiHelpers jeiHelpers, Item resultItem, String itemName) {
        return ArrowShotRecipeMaker.getRecipes(jeiHelpers, resultItem, resultItem, 0.2f, itemName);
    }

    public static List<RecipeHolder<CraftingRecipe>> getRecipes(IJeiHelpers jeiHelpers, Item resultItem, Item inputItem, float durationFactor, String itemName) {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        String group = "reliquary.potion." + itemName;
        for (PotionEssence essence : PotionMap.uniquePotions) {
            ItemStack potion = new ItemStack((ItemLike)ModItems.LINGERING_POTION.get());
            PotionHelper.addPotionContentsToStack(potion, essence.getPotionContents());
            ItemStack result = new ItemStack((ItemLike)resultItem);
            result.setCount(8);
            PotionHelper.addPotionContentsToStack(result, PotionHelper.changePotionEffectsDuration(essence.getPotionContents(), durationFactor));
            IVanillaRecipeFactory vanillaRecipeFactory = jeiHelpers.getVanillaRecipeFactory();
            CraftingRecipe recipe = vanillaRecipeFactory.createShapedRecipeBuilder(CraftingBookCategory.MISC, (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(result)).group(group).define(Character.valueOf('a'), Ingredient.of((ItemLike)inputItem)).define(Character.valueOf('p'), Ingredient.of((ItemLike)potion.getItem()), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(potion)).pattern("aaa").pattern("apa").pattern("aaa").build();
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)RegistryHelper.getRegistryName(resultItem)), (Recipe)recipe));
        }
        return recipes;
    }
}

