/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.magazines;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import reliquary.init.ModItems;
import reliquary.reference.Config;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionMap;

public class MagazineRecipeMaker {
    private MagazineRecipeMaker() {
    }

    public static List<RecipeHolder<CraftingRecipe>> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        MagazineRecipeMaker.addRegularMagazines(jeiHelpers, recipes);
        if (Boolean.FALSE.equals(Config.COMMON.disable.disablePotions.get())) {
            MagazineRecipeMaker.addPotionMagazines(jeiHelpers, recipes);
        }
        return recipes;
    }

    private static void addRegularMagazines(IJeiHelpers jeiHelpers, List<RecipeHolder<CraftingRecipe>> recipes) {
        ImmutableMap bulletMagazines = new ImmutableMap.Builder().put((Object)ModItems.NEUTRAL_BULLET.get(), (Object)ModItems.NEUTRAL_MAGAZINE.get()).put((Object)ModItems.EXORCISM_BULLET.get(), (Object)ModItems.EXORCISM_MAGAZINE.get()).put((Object)ModItems.BLAZE_BULLET.get(), (Object)ModItems.BLAZE_MAGAZINE.get()).put((Object)ModItems.ENDER_BULLET.get(), (Object)ModItems.ENDER_MAGAZINE.get()).put((Object)ModItems.CONCUSSIVE_BULLET.get(), (Object)ModItems.CONCUSSIVE_MAGAZINE.get()).put((Object)ModItems.BUSTER_BULLET.get(), (Object)ModItems.BUSTER_MAGAZINE.get()).put((Object)ModItems.SEEKER_BULLET.get(), (Object)ModItems.SEEKER_MAGAZINE.get()).put((Object)ModItems.SAND_BULLET.get(), (Object)ModItems.SAND_MAGAZINE.get()).put((Object)ModItems.STORM_BULLET.get(), (Object)ModItems.STORM_MAGAZINE.get()).build();
        for (Map.Entry bulletMagazine : bulletMagazines.entrySet()) {
            ItemStack output = new ItemStack((ItemLike)bulletMagazine.getValue());
            IVanillaRecipeFactory vanillaRecipeFactory = jeiHelpers.getVanillaRecipeFactory();
            CraftingRecipe recipe = vanillaRecipeFactory.createShapedRecipeBuilder(CraftingBookCategory.MISC, (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(output)).group("reliquary.magazine").define(Character.valueOf('b'), Ingredient.of((ItemLike)((ItemLike)bulletMagazine.getKey()))).define(Character.valueOf('m'), Ingredient.of((ItemLike)((ItemLike)ModItems.EMPTY_MAGAZINE.get()))).pattern("bbb").pattern("bmb").pattern("bbb").build();
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)RegistryHelper.getRegistryName(output.getItem())), (Recipe)recipe));
        }
    }

    private static void addPotionMagazines(IJeiHelpers jeiHelpers, List<RecipeHolder<CraftingRecipe>> recipes) {
        for (PotionEssence essence : PotionMap.uniquePotions) {
            PotionContents potionContents = PotionHelper.changePotionEffectsDuration(essence.getPotionContents(), 0.2f);
            ItemStack output = new ItemStack((ItemLike)ModItems.NEUTRAL_MAGAZINE.get());
            PotionHelper.addPotionContentsToStack(output, potionContents);
            ItemStack potionBullet = new ItemStack((ItemLike)ModItems.NEUTRAL_BULLET.get());
            if (potionContents.hasEffects()) {
                PotionHelper.addPotionContentsToStack(potionBullet, potionContents);
            }
            IVanillaRecipeFactory vanillaRecipeFactory = jeiHelpers.getVanillaRecipeFactory();
            CraftingRecipe recipe = vanillaRecipeFactory.createShapedRecipeBuilder(CraftingBookCategory.MISC, (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(output)).group("reliquary.potion.magazine").define(Character.valueOf('b'), Ingredient.of((ItemLike)potionBullet.getItem()), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(potionBullet)).define(Character.valueOf('m'), Ingredient.of((ItemLike)((ItemLike)ModItems.EMPTY_MAGAZINE.get()))).pattern("bbb").pattern("bmb").pattern("bbb").build();
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)RegistryHelper.getRegistryName(output.getItem())), (Recipe)recipe));
        }
    }
}

