/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.CustomDisplayIngredient;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModItems;
import reliquary.item.AlkahestryTomeItem;

public class AlkahestryDrainRecipe
implements CraftingRecipe {
    private final int chargeToDrain;
    private final ItemStack result;
    private final Ingredient tomeIngredient;

    public AlkahestryDrainRecipe(int chargeToDrain, ItemStack result) {
        this.chargeToDrain = chargeToDrain;
        this.result = result;
        this.tomeIngredient = CustomDisplayIngredient.of((Ingredient)Ingredient.of((ItemLike)((ItemLike)ModItems.ALKAHESTRY_TOME.get())), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(AlkahestryTomeItem.setCharge(new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get()), AlkahestryTomeItem.getChargeLimit())));
        AlkahestryRecipeRegistry.setDrainRecipe(this);
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingInput inv, Level level) {
        boolean hasTome = false;
        ItemStack tome = ItemStack.EMPTY;
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (stack.isEmpty()) continue;
            if (!hasTome && stack.getItem() == ModItems.ALKAHESTRY_TOME.get()) {
                hasTome = true;
                tome = stack;
                continue;
            }
            return false;
        }
        return hasTome && AlkahestryTomeItem.getCharge(tome) > 0;
    }

    public ItemStack getResultItem() {
        return this.result.copy();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create(List.of(this.tomeIngredient));
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack tome = this.getTome(inv).copy();
        int charge = AlkahestryTomeItem.getCharge(tome);
        ItemStack ret = this.result.copy();
        ret.setCount(Math.min(ret.getMaxStackSize(), charge / this.chargeToDrain));
        return ret;
    }

    private ItemStack getTome(CraftingInput inv) {
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (stack.getItem() != ModItems.ALKAHESTRY_TOME.get()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList ret = super.getRemainingItems(inv);
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (stack.getItem() != ModItems.ALKAHESTRY_TOME.get()) continue;
            ItemStack tome = stack.copy();
            int charge = AlkahestryTomeItem.getCharge(tome);
            int itemCount = Math.min(this.result.getMaxStackSize(), charge / this.chargeToDrain);
            ((AlkahestryTomeItem)ModItems.ALKAHESTRY_TOME.get()).useCharge(tome, itemCount * this.chargeToDrain);
            ret.set(slot, (Object)tome);
        }
        return ret;
    }

    public RecipeSerializer<? extends CraftingRecipe> getSerializer() {
        return ModItems.ALKAHESTRY_DRAIN_SERIALIZER.get();
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    private ItemStack getResult() {
        return this.result;
    }

    private Integer getChargeToDrain() {
        return this.chargeToDrain;
    }

    public static class Serializer
    implements RecipeSerializer<AlkahestryDrainRecipe> {
        private static final MapCodec<AlkahestryDrainRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("charge").forGetter(recipe -> recipe.chargeToDrain), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, AlkahestryDrainRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, AlkahestryDrainRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, AlkahestryDrainRecipe::getChargeToDrain, (StreamCodec)ItemStack.STREAM_CODEC, AlkahestryDrainRecipe::getResult, AlkahestryDrainRecipe::new);

        public MapCodec<AlkahestryDrainRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlkahestryDrainRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

