/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import reliquary.crafting.AlkahestryChargingRecipe;
import reliquary.crafting.AlkahestryCraftingRecipe;
import reliquary.crafting.AlkahestryDrainRecipe;

public class AlkahestryRecipeRegistry {
    @Nullable
    private static AlkahestryDrainRecipe drainRecipe = null;
    private static final List<AlkahestryCraftingRecipe> craftingRecipes = new ArrayList<AlkahestryCraftingRecipe>();
    private static final List<AlkahestryChargingRecipe> chargingRecipes = new ArrayList<AlkahestryChargingRecipe>();

    private AlkahestryRecipeRegistry() {
    }

    static void setDrainRecipe(AlkahestryDrainRecipe drainRecipe) {
        AlkahestryRecipeRegistry.drainRecipe = drainRecipe;
    }

    public static Optional<AlkahestryDrainRecipe> getDrainRecipe() {
        return Optional.ofNullable(drainRecipe);
    }

    public static List<AlkahestryCraftingRecipe> getCraftingRecipes() {
        return craftingRecipes;
    }

    static void registerCraftingRecipe(AlkahestryCraftingRecipe alkahestryCraftingRecipe) {
        craftingRecipes.add(alkahestryCraftingRecipe);
    }

    static void registerChargingRecipe(AlkahestryChargingRecipe alkahestryChargingRecipe) {
        chargingRecipes.add(alkahestryChargingRecipe);
    }

    public static List<AlkahestryChargingRecipe> getChargingRecipes() {
        return chargingRecipes;
    }

    public static void onResourceReload(AddServerReloadListenersEvent event) {
        drainRecipe = null;
        craftingRecipes.clear();
        chargingRecipes.clear();
    }
}

