/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import reliquary.crafting.PotionEffectsRecipe;
import reliquary.crafting.conditions.PotionsEnabledCondition;

public class PotionEffectsRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private final float durationFactor;

    private PotionEffectsRecipeBuilder(ItemLike result, int count, float durationFactor) {
        this.result = result.asItem();
        this.count = count;
        this.durationFactor = durationFactor;
    }

    public static PotionEffectsRecipeBuilder potionEffectsRecipe(ItemLike item, int count, float durationFactor) {
        return new PotionEffectsRecipeBuilder(item, count, durationFactor);
    }

    public PotionEffectsRecipeBuilder define(Character symbol, ItemLike item) {
        return this.define(symbol, Ingredient.of((ItemLike)item));
    }

    public PotionEffectsRecipeBuilder define(Character symbol, Ingredient ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredient);
        return this;
    }

    public PotionEffectsRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public PotionEffectsRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.getFirst().length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public PotionEffectsRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public void save(RecipeOutput recipeOutput, ResourceKey<Recipe<?>> id) {
        Advancement.Builder advancementBuilder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(id)).rewards(AdvancementRewards.Builder.recipe(id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        recipeOutput.withConditions(new ICondition[]{new PotionsEnabledCondition()}).accept(id, (Recipe)new PotionEffectsRecipe(Objects.requireNonNullElse(this.group, ""), this.ensureValid(id), new ItemStack((ItemLike)this.result, this.count), this.durationFactor), null);
    }

    private ShapedRecipePattern ensureValid(ResourceKey<Recipe<?>> id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
        return ShapedRecipePattern.of(this.key, this.rows);
    }
}

