/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.Potion;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.blockstates.Condition;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.conditional.FishingRodCast;
import net.minecraft.client.renderer.item.properties.conditional.HasComponent;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.item.DynamicFluidContainerModel;
import reliquary.Reliquary;
import reliquary.block.AlkahestryAltarBlock;
import reliquary.block.ApothecaryCauldronBlock;
import reliquary.block.FertileLilyPadBlock;
import reliquary.block.PedestalBlock;
import reliquary.client.color.item.CharmTintSources;
import reliquary.client.model.VoidTearItemModel;
import reliquary.init.ModBlocks;
import reliquary.init.ModFluids;
import reliquary.init.ModItems;
import reliquary.item.BulletItem;
import reliquary.item.ItemBase;
import reliquary.item.MagazineItem;
import reliquary.item.PotionItemBase;
import reliquary.item.VoidTearItem;
import reliquary.item.properties.conditional.InfernalTearEmpty;

public class ReliquaryModelProvider
extends ModelProvider {
    private static final TextureSlot WOOL_SLOT = TextureSlot.create((String)"wool");
    private static final ModelTemplate PEDESTAL_TEMPLATE = ModelTemplates.create((String)Reliquary.getRL("pedestal").toString(), (TextureSlot[])new TextureSlot[]{WOOL_SLOT});
    private static final ModelTemplate PASSIVE_PEDESTAL_TEMPLATE = ModelTemplates.create((String)Reliquary.getRL("passive_pedestal").toString(), (TextureSlot[])new TextureSlot[]{WOOL_SLOT});
    private final Set<Item> itemsWithGeneratedModels = new HashSet<Item>();

    public ReliquaryModelProvider(PackOutput output) {
        super(output, "reliquary");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.itemsWithGeneratedModels.clear();
        this.generateVoidTear(itemModels);
        this.generateRodOfLyssa(itemModels);
        this.generateInfernalTear(itemModels);
        this.generateMagazinesAndBullets(itemModels);
        this.generatePotion(itemModels, ModItems.POTION.get());
        this.generatePotion(itemModels, ModItems.SPLASH_POTION.get());
        this.generatePotion(itemModels, ModItems.LINGERING_POTION.get());
        this.generatePotionEssence(itemModels);
        this.generateTippedArrow(itemModels);
        this.generateCharmAndFragment(itemModels);
        this.generateHandHeldModel(itemModels, (Item)ModItems.MERCY_CROSS.get());
        this.generateHandHeldModel(itemModels, ModItems.PYROMANCER_STAFF.get());
        this.generateHandHeldModel(itemModels, ModItems.ENDER_STAFF.get());
        this.generateHandHeldModel(itemModels, ModItems.GLACIAL_STAFF.get());
        this.generateHandHeldModel(itemModels, ModItems.HARVEST_ROD.get());
        this.generateHandHeldModel(itemModels, ModItems.ICE_MAGUS_ROD.get());
        this.generateHandHeldModel(itemModels, (Item)ModItems.MAGICBANE.get());
        this.generateHandHeldModel(itemModels, ModItems.RENDING_GALE.get());
        this.generateHandHeldModel(itemModels, ModItems.SERPENT_STAFF.get());
        this.generateHandHeldModel(itemModels, ModItems.SOJOURNER_STAFF.get());
        this.generateCustomModel(itemModels, ModItems.HANDGUN.get(), ItemModelUtils.plainModel((ResourceLocation)Reliquary.getRL("handgun").withPrefix("item/")));
        this.generateItemBaseFlatItemModels(itemModels);
        itemModels.generateFlatItem((Item)ModItems.WITCH_HAT.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModItems.SHEARS_OF_WINTER.get(), ModelTemplates.FLAT_ITEM);
        this.generateXpBucket(itemModels);
        this.generateAlkahestryAltar(blockModels);
        ReliquaryModelProvider.generateCustomModelBlock(blockModels, ModBlocks.APOTHECARY_CAULDRON.get(), this.createLevelDispatch());
        ReliquaryModelProvider.generateCustomModelBlock(blockModels, ModBlocks.APOTHECARY_MORTAR.get(), BlockModelGenerators.createHorizontalFacingDispatch());
        ReliquaryModelProvider.generateFertileLilypad(blockModels);
        blockModels.createNormalTorch((Block)ModBlocks.INTERDICTION_TORCH.get(), (Block)ModBlocks.WALL_INTERDICTION_TORCH.get());
        ReliquaryModelProvider.generateCustomModelBlock(blockModels, ModBlocks.WRAITH_NODE.get());
        ModBlocks.PEDESTALS.forEach((dye, pedestal) -> ReliquaryModelProvider.generatePedestal(blockModels, (Block)pedestal.get(), dye));
        ModBlocks.PASSIVE_PEDESTALS.forEach((dye, pedestal) -> ReliquaryModelProvider.generatePassivePedestal(blockModels, (Block)pedestal.get(), dye));
    }

    private void generateXpBucket(ItemModelGenerators itemModels) {
        itemModels.itemModelOutput.accept(ModItems.XP_BUCKET.get(), (ItemModel.Unbaked)new DynamicFluidContainerModel.Unbaked(new DynamicFluidContainerModel.Textures(Optional.of(ResourceLocation.withDefaultNamespace((String)"item/bucket")), Optional.of(ResourceLocation.withDefaultNamespace((String)"item/bucket")), Optional.of(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item/mask/bucket_fluid")), Optional.empty()), (Fluid)ModFluids.XP_STILL.get(), false, false, false));
    }

    private void generateAlkahestryAltar(BlockModelGenerators blockModels) {
        Block block = ModBlocks.ALKAHESTRY_ALTAR.get();
        ResourceLocation blockModelId = TexturedModel.CUBE.create(block, blockModels.modelOutput);
        ResourceLocation activeAlkahestryAltar = Reliquary.getRL("alkahestry_altar_active").withPrefix("block/");
        ResourceLocation activeBlockModelId = ModelTemplates.CUBE_ALL.create(activeAlkahestryAltar, TextureMapping.cube((ResourceLocation)activeAlkahestryAltar), blockModels.modelOutput);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId)).with(PropertyDispatch.property((Property)AlkahestryAltarBlock.ACTIVE).generate(active -> {
            if (active.booleanValue()) {
                return Variant.variant().with(VariantProperties.MODEL, (Object)activeBlockModelId);
            }
            return Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId);
        })));
        blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)blockModelId));
    }

    private PropertyDispatch createLevelDispatch() {
        return PropertyDispatch.property((Property)ApothecaryCauldronBlock.LEVEL).generate(level -> {
            if (level == 0) {
                return Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)ModBlocks.APOTHECARY_CAULDRON.get()));
            }
            return Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)ModBlocks.APOTHECARY_CAULDRON.get(), (String)("_level" + level)));
        });
    }

    private void generateCharmAndFragment(ItemModelGenerators itemModels) {
        Item charmItem = ModItems.MOB_CHARM.get();
        ResourceLocation modelLocation = ModelLocationUtils.getModelLocation((Item)charmItem);
        itemModels.generateLayeredItem(modelLocation, TextureMapping.getItemTexture((Item)charmItem), TextureMapping.getItemTexture((Item)charmItem, (String)"_overlay_1"), TextureMapping.getItemTexture((Item)charmItem, (String)"_overlay_2"));
        this.generateCustomModel(itemModels, charmItem, ItemModelUtils.tintedModel((ResourceLocation)modelLocation, (ItemTintSource[])new ItemTintSource[]{ItemModelGenerators.BLANK_LAYER, CharmTintSources.Main.INSTANCE, CharmTintSources.Accent.INSTANCE}));
        Item fragmentItem = ModItems.MOB_CHARM_FRAGMENT.get();
        this.generateCustomModel(itemModels, fragmentItem, ItemModelUtils.tintedModel((ResourceLocation)itemModels.generateLayeredItem(fragmentItem, TextureMapping.getItemTexture((Item)fragmentItem), TextureMapping.getItemTexture((Item)fragmentItem, (String)"_overlay")), (ItemTintSource[])new ItemTintSource[]{CharmTintSources.Main.INSTANCE, CharmTintSources.Accent.INSTANCE}));
    }

    private void generateMagazinesAndBullets(ItemModelGenerators itemModels) {
        ModItems.ITEMS.getEntries().stream().filter(entry -> entry.get() instanceof BulletItem && entry.get() != ModItems.EMPTY_BULLET.get() && entry.get() != ModItems.EMPTY_MAGAZINE.get()).forEach(entry -> {
            ResourceLocation onTrueLocation = ModelLocationUtils.getModelLocation((Item)((Item)entry.get()), (String)"_potion");
            ResourceLocation baseTextureLocation = TextureMapping.getItemTexture((Item)((Item)entry.get()));
            String type = entry.get() instanceof MagazineItem ? "magazine" : "bullet";
            String folder = entry.get() instanceof MagazineItem ? "magazines/" : "bullets/";
            ResourceLocation potionOverlayLocation = Reliquary.getRL(type + "_potion_overlay").withPrefix("item/" + folder);
            ItemModel.Unbaked onTrue = ItemModelUtils.tintedModel((ResourceLocation)itemModels.generateLayeredItem(onTrueLocation, baseTextureLocation, potionOverlayLocation), (ItemTintSource[])new ItemTintSource[]{ItemModelGenerators.BLANK_LAYER, new Potion()});
            ItemModel.Unbaked onFalse = ItemModelUtils.tintedModel((ResourceLocation)itemModels.createFlatItemModel((Item)entry.get(), ModelTemplates.FLAT_ITEM), (ItemTintSource[])new ItemTintSource[0]);
            this.generateConditional(itemModels, (Item)entry.get(), (ConditionalItemModelProperty)new HasComponent(DataComponents.POTION_CONTENTS, false), onTrue, onFalse);
        });
    }

    private void generateTippedArrow(ItemModelGenerators itemModels) {
        itemModels.generateTippedArrow((Item)ModItems.TIPPED_ARROW.get());
        this.itemsWithGeneratedModels.add((Item)ModItems.TIPPED_ARROW.get());
    }

    private void generatePotionEssence(ItemModelGenerators itemModels) {
        this.generateCustomModel(itemModels, ModItems.POTION_ESSENCE.get(), ItemModelUtils.tintedModel((ResourceLocation)itemModels.createFlatItemModel((Item)ModItems.POTION_ESSENCE.get(), ModelTemplates.FLAT_ITEM), (ItemTintSource[])new ItemTintSource[]{new Potion()}));
    }

    private void generatePotion(ItemModelGenerators itemModels, PotionItemBase potionItem) {
        this.generateCustomModel(itemModels, potionItem, ItemModelUtils.tintedModel((ResourceLocation)itemModels.generateLayeredItem((Item)potionItem, TextureMapping.getItemTexture((Item)potionItem), TextureMapping.getItemTexture((Item)potionItem, (String)"_overlay")), (ItemTintSource[])new ItemTintSource[]{ItemModelGenerators.BLANK_LAYER, new Potion()}));
    }

    private void generateRodOfLyssa(ItemModelGenerators itemModels) {
        ItemModel.Unbaked onTrue = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel((Item)ModItems.ROD_OF_LYSSA.get(), "_cast", ModelTemplates.FLAT_HANDHELD_ROD_ITEM));
        ItemModel.Unbaked onFalse = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel((Item)ModItems.ROD_OF_LYSSA.get(), ModelTemplates.FLAT_HANDHELD_ROD_ITEM));
        this.generateConditional(itemModels, ModItems.ROD_OF_LYSSA.get(), (ConditionalItemModelProperty)new FishingRodCast(), onTrue, onFalse);
    }

    private void generateInfernalTear(ItemModelGenerators itemModels) {
        ItemModel.Unbaked onTrue = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel((Item)ModItems.INFERNAL_TEAR.get(), "_empty", ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked onFalse = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel((Item)ModItems.INFERNAL_TEAR.get(), ModelTemplates.FLAT_ITEM));
        this.generateConditional(itemModels, ModItems.INFERNAL_TEAR.get(), new InfernalTearEmpty(), onTrue, onFalse);
    }

    private void generateConditional(ItemModelGenerators itemModels, Item item, ConditionalItemModelProperty property, ItemModel.Unbaked onTrue, ItemModel.Unbaked onFalse) {
        this.generateCustomModel(itemModels, item, ItemModelUtils.conditional((ConditionalItemModelProperty)property, (ItemModel.Unbaked)onTrue, (ItemModel.Unbaked)onFalse));
    }

    private void generateVoidTear(ItemModelGenerators itemModels) {
        VoidTearItem voidTearItem = ModItems.VOID_TEAR.get();
        ItemModel.Unbaked filledTear = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel((Item)voidTearItem, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked emptyTear = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel((Item)voidTearItem, "_empty", ModelTemplates.FLAT_ITEM));
        VoidTearItemModel.Unbaked unbakedSpecialModel = new VoidTearItemModel.Unbaked(emptyTear, filledTear);
        this.generateCustomModel(itemModels, voidTearItem, unbakedSpecialModel);
    }

    private void generateCustomModel(ItemModelGenerators itemModels, Item item, ItemModel.Unbaked unbakedCustomModel) {
        this.itemsWithGeneratedModels.add(item);
        itemModels.itemModelOutput.accept(item, unbakedCustomModel);
    }

    private void generateHandHeldModel(ItemModelGenerators itemModels, Item item) {
        this.itemsWithGeneratedModels.add(item);
        itemModels.generateFlatItem(item, ModelTemplates.FLAT_HANDHELD_ITEM);
    }

    protected void generateItemBaseFlatItemModels(ItemModelGenerators itemModels) {
        ModItems.ITEMS.getEntries().stream().filter(entry -> entry.get() instanceof ItemBase && !this.itemsWithGeneratedModels.contains(entry.get())).forEach(entry -> itemModels.generateFlatItem((Item)entry.get(), ModelTemplates.FLAT_ITEM));
    }

    private static void generateCustomModelBlock(BlockModelGenerators blockModels, Block block, PropertyDispatch propertyDispatch) {
        ResourceLocation blockModelId = ModelLocationUtils.getModelLocation((Block)block);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId)).with(propertyDispatch));
        blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)blockModelId));
    }

    private static void generatePassivePedestal(BlockModelGenerators blockModels, Block pedestal, DyeColor color) {
        ResourceLocation blockModelId = PASSIVE_PEDESTAL_TEMPLATE.create(pedestal, new TextureMapping().put(WOOL_SLOT, ResourceLocation.parse((String)(color.getName() + "_wool")).withPrefix("block/")), blockModels.modelOutput);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)pedestal, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId)).with(BlockModelGenerators.createHorizontalFacingDispatch()));
        blockModels.itemModelOutput.accept(pedestal.asItem(), ItemModelUtils.plainModel((ResourceLocation)blockModelId));
    }

    private static void generatePedestal(BlockModelGenerators blockModels, Block pedestal, DyeColor color) {
        ResourceLocation blockModelId = PEDESTAL_TEMPLATE.create(pedestal, new TextureMapping().put(WOOL_SLOT, ResourceLocation.parse((String)(color.getName() + "_wool")).withPrefix("block/")), blockModels.modelOutput);
        ResourceLocation buttonOnModel = Reliquary.getRL("block/pedestal_button_on");
        ResourceLocation buttonOffModel = Reliquary.getRL("block/pedestal_button_off");
        blockModels.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)pedestal).with((Condition)Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH), Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId)).with((Condition)Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST), Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH), Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).with((Condition)Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST), Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).with(Condition.and((Condition[])new Condition[]{Condition.condition().term((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(true)), Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)}), Variant.variant().with(VariantProperties.MODEL, (Object)buttonOnModel)).with(Condition.and((Condition[])new Condition[]{Condition.condition().term((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(true)), Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)}), Variant.variant().with(VariantProperties.MODEL, (Object)buttonOnModel).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with(Condition.and((Condition[])new Condition[]{Condition.condition().term((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(true)), Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)}), Variant.variant().with(VariantProperties.MODEL, (Object)buttonOnModel).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).with(Condition.and((Condition[])new Condition[]{Condition.condition().term((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(true)), Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)}), Variant.variant().with(VariantProperties.MODEL, (Object)buttonOnModel).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).with(Condition.and((Condition[])new Condition[]{Condition.condition().term((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(false)), Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)}), Variant.variant().with(VariantProperties.MODEL, (Object)buttonOffModel)).with(Condition.and((Condition[])new Condition[]{Condition.condition().term((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(false)), Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)}), Variant.variant().with(VariantProperties.MODEL, (Object)buttonOffModel).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with(Condition.and((Condition[])new Condition[]{Condition.condition().term((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(false)), Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)}), Variant.variant().with(VariantProperties.MODEL, (Object)buttonOffModel).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).with(Condition.and((Condition[])new Condition[]{Condition.condition().term((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(false)), Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)}), Variant.variant().with(VariantProperties.MODEL, (Object)buttonOffModel).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)));
        blockModels.itemModelOutput.accept(pedestal.asItem(), ItemModelUtils.plainModel((ResourceLocation)blockModelId));
    }

    private static void generateCustomModelBlock(BlockModelGenerators blockModels, Block block) {
        ResourceLocation blockModelId = ModelLocationUtils.getModelLocation((Block)block);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId)));
        blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)blockModelId));
    }

    private static void generateFertileLilypad(BlockModelGenerators blockModels) {
        FertileLilyPadBlock block = ModBlocks.FERTILE_LILY_PAD.get();
        ResourceLocation blockModelId = ModelLocationUtils.getModelLocation((Block)block);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant[])new Variant[]{Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId), Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90), Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180), Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)}));
        ResourceLocation itemModelId = blockModels.createFlatItemModelWithBlockTexture(block.asItem(), (Block)block);
        blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)itemModelId));
    }
}

