/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import reliquary.Reliquary;
import reliquary.crafting.MobCharmRecipeBuilder;
import reliquary.crafting.PotionEffectsRecipeBuilder;
import reliquary.crafting.SpawnEggRecipeBuilder;
import reliquary.crafting.alkahestry.ChargingRecipeBuilder;
import reliquary.crafting.alkahestry.CraftingRecipeBuilder;
import reliquary.crafting.alkahestry.DrainRecipeBuilder;
import reliquary.crafting.conditions.AlkahestryEnabledCondition;
import reliquary.crafting.conditions.CharmEnabledCondition;
import reliquary.crafting.conditions.HandgunEnabledCondition;
import reliquary.crafting.conditions.MobDropsCraftableCondition;
import reliquary.crafting.conditions.PassivePedestalEnabledCondition;
import reliquary.crafting.conditions.PedestalEnabledCondition;
import reliquary.crafting.conditions.PotionsEnabledCondition;
import reliquary.crafting.conditions.SpawnEggEnabledCondition;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.item.BulletItem;
import reliquary.item.MagazineItem;
import reliquary.util.RegistryHelper;

public class ReliquaryRecipeProvider
extends RecipeProvider {
    private static final TagKey<Item> INGOTS_COPPER = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"forge:ingots/copper"));
    private static final TagKey<Item> INGOTS_STEEL = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"forge:ingots/steel"));
    private static final TagKey<Item> INGOTS_SILVER = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"forge:ingots/silver"));
    private static final TagKey<Item> INGOTS_TIN = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"forge:ingots/tin"));
    private static final String HAS_GUNPOWDER_CRITERION = "has_gunpowder";
    private static final String HAS_NEBULOUS_HEART_CRITERION = "has_nebulous_heart";
    private static final String HAS_FERTILE_ESSENCE_CRITERION = "has_fertile_essence";
    private static final String HAS_MOLTEN_CORE_CRITERION = "has_molten_core";
    private static final String HAS_CATALYZING_GLAND_CRITERIION = "has_catalyzing_gland";
    private static final String MOB_CHARM_FRAGMENTS_FOLDER = "mob_charm_fragments/";
    private static final String UNCRAFTING_FOLDER = "uncrafting/";
    private static final String HAS_CHELICERAE_CRITERION = "has_chelicerae";
    private static final String HAS_SLIME_PEARL_CRITERION = "has_slime_pearl";
    private static final String HAS_WITCH_HAT_CRITERION = "has_witch_hat";
    private static final String HAS_ZOMBIE_HEART_CRITERION = "has_zombie_heart";
    private static final String HAS_GUARDIAN_SPIKE_CRITERION = "has_guardian_spike";
    private static final String HAS_VOID_TEAR_CRITERION = "has_void_tear";
    private static final String HAS_FROZEN_CORE_CRITERION = "has_frozen_core";
    private static final String HAS_WITHERED_RIB_CRITERION = "has_withered_rib";
    private static final String HAS_MOB_CHARM_FRAGMENT_CRITERION = "has_mob_charm_fragment";
    private static final String HAS_INFERNAL_CLAW_CRITERION = "has_infernal_claw";
    private final HolderGetter<Item> items;

    public ReliquaryRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
        super(provider, recipeOutput);
        this.items = provider.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        this.registerHandgunRecipes(this.output);
        this.registerAlkahestryRecipes(this.output);
        this.registerPotionRecipes(this.output);
        this.registerPedestalRecipes(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ALKAHESTRY_ALTAR_ITEM.get())).requires(Tags.Items.OBSIDIANS).requires((ItemLike)Items.REDSTONE_LAMP).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FERTILE_LILY_PAD_ITEM.get())).requires((ItemLike)ModItems.FERTILE_ESSENCE.get()).requires((ItemLike)ModItems.FERTILE_ESSENCE.get()).requires((ItemLike)ModItems.FERTILE_ESSENCE.get()).requires((ItemLike)Items.LILY_PAD).unlockedBy(HAS_FERTILE_ESSENCE_CRITERION, this.has((ItemLike)ModItems.FERTILE_ESSENCE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.INTERDICTION_TORCH_ITEM.get())).requires((ItemLike)ModItems.BAT_WING.get()).requires(Tags.Items.RODS_BLAZE).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).unlockedBy(HAS_MOLTEN_CORE_CRITERION, this.has((ItemLike)ModItems.MOLTEN_CORE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.WRAITH_NODE_ITEM.get())).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).requires(Tags.Items.GEMS_EMERALD).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(this.output);
        this.registerCraftableMobDropRecipes();
        this.registerCharmFragmentRecipes();
        this.registerIngredientRecipes();
        this.registerUncraftingRecipes();
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ANGELHEART_VIAL.get())).pattern("GBG").pattern("GCG").pattern("FGF").define(Character.valueOf('G'), Tags.Items.GLASS_PANES).define(Character.valueOf('B'), (ItemLike)Items.MILK_BUCKET).define(Character.valueOf('C'), (ItemLike)ModItems.INFERNAL_CLAW.get()).define(Character.valueOf('F'), (ItemLike)ModItems.FERTILE_ESSENCE.get()).unlockedBy(HAS_FERTILE_ESSENCE_CRITERION, this.has((ItemLike)ModItems.FERTILE_ESSENCE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ANGELIC_FEATHER.get())).requires(Tags.Items.FEATHERS).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).requires((ItemLike)ModItems.BAT_WING.get()).requires((ItemLike)ModItems.FERTILE_ESSENCE.get()).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.DESTRUCTION_CATALYST.get())).requires((ItemLike)Items.FLINT_AND_STEEL).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).requires((ItemLike)ModItems.INFERNAL_TEAR.get()).unlockedBy(HAS_MOLTEN_CORE_CRITERION, this.has((ItemLike)ModItems.MOLTEN_CORE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.EMPEROR_CHALICE.get())).requires(Tags.Items.GEMS_EMERALD).requires(Tags.Items.INGOTS_GOLD).requires((ItemLike)Items.BUCKET).requires(DataComponentIngredient.of((boolean)true, (ItemStack)new ItemStack((ItemLike)ModItems.VOID_TEAR.get()))).unlockedBy(HAS_VOID_TEAR_CRITERION, this.has((ItemLike)ModItems.VOID_TEAR.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ENDER_STAFF.get())).pattern(" BE").pattern("NVB").pattern("SN ").define(Character.valueOf('B'), (ItemLike)ModItems.BAT_WING.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('V'), DataComponentIngredient.of((boolean)true, (ItemStack)new ItemStack((ItemLike)ModItems.VOID_TEAR.get()))).define(Character.valueOf('N'), (ItemLike)ModItems.NEBULOUS_HEART.get()).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.FORTUNE_COIN.get())).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).requires(Tags.Items.NUGGETS_GOLD).requires((ItemLike)ModItems.SLIME_PEARL.get()).requires((ItemLike)ModItems.BAT_WING.get()).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GLACIAL_STAFF.get())).requires((ItemLike)ModItems.ICE_MAGUS_ROD.get()).requires(DataComponentIngredient.of((boolean)true, (ItemStack)new ItemStack((ItemLike)ModItems.VOID_TEAR.get()))).requires((ItemLike)ModItems.FROZEN_CORE.get()).requires((ItemLike)ModItems.SHEARS_OF_WINTER.get()).unlockedBy(HAS_VOID_TEAR_CRITERION, this.has((ItemLike)ModItems.VOID_TEAR.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GLOWING_BREAD.get()), (int)3).requires((ItemLike)Items.BREAD).requires((ItemLike)Items.BREAD).requires((ItemLike)Items.BREAD).requires((ItemLike)ModItems.GLOWING_WATER.get()).unlockedBy("has_glowing_water", this.has((ItemLike)ModItems.GLOWING_WATER.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GLOWING_WATER.get())).pattern("GBG").pattern("GDG").pattern("NGP").define(Character.valueOf('G'), Tags.Items.GLASS_PANES).define(Character.valueOf('B'), (ItemLike)Items.WATER_BUCKET).define(Character.valueOf('D'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('P'), Tags.Items.GUNPOWDERS).define(Character.valueOf('N'), Tags.Items.CROPS_NETHER_WART).unlockedBy("has_nether_wart", this.hasTag((TagKey<Item>)Tags.Items.CROPS_NETHER_WART)).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GLOWING_WATER.get())).requires((ItemLike)ModItems.EMPTY_POTION_VIAL.get()).requires((ItemLike)Items.WATER_BUCKET).requires(Tags.Items.DUSTS_GLOWSTONE).requires(Tags.Items.GUNPOWDERS).requires(Tags.Items.CROPS_NETHER_WART).unlockedBy("has_empty_potion_vial", this.has((ItemLike)ModItems.EMPTY_POTION_VIAL.get())).save(this.output, this.getRecipeKey("glowing_water_from_potion_vial"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET).requires((ItemLike)ModItems.EMPTY_BULLET.get()).requires((ItemLike)ModItems.EMPTY_BULLET.get()).requires((ItemLike)ModItems.EMPTY_BULLET.get()).requires((ItemLike)ModItems.EMPTY_BULLET.get()).unlockedBy("has_empty_bullet", this.has((ItemLike)ModItems.EMPTY_BULLET.get())).save(this.output, this.getRecipeKey("gold_nugget"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.HARVEST_ROD.get())).pattern(" RF").pattern("VTR").pattern("SV ").define(Character.valueOf('R'), (ItemLike)Items.ROSE_BUSH).define(Character.valueOf('F'), (ItemLike)ModItems.FERTILE_ESSENCE.get()).define(Character.valueOf('V'), (ItemLike)Items.VINE).define(Character.valueOf('T'), DataComponentIngredient.of((boolean)true, (ItemStack)new ItemStack((ItemLike)ModItems.VOID_TEAR.get()))).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy(HAS_VOID_TEAR_CRITERION, this.has((ItemLike)ModItems.VOID_TEAR.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.HERO_MEDALLION.get())).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).requires((ItemLike)ModItems.FORTUNE_COIN.get()).requires((ItemLike)ModItems.WITCH_HAT.get()).requires((ItemLike)ModItems.INFERNAL_TEAR.get()).unlockedBy("has_infernal_tear", this.has((ItemLike)ModItems.INFERNAL_TEAR.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.HOLY_HAND_GRENADE.get()), (int)4).requires((ItemLike)ModItems.GLOWING_WATER.get()).requires(Tags.Items.NUGGETS_GOLD).requires((ItemLike)Items.TNT).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).unlockedBy("has_glowing_water", this.has((ItemLike)ModItems.GLOWING_WATER.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ICE_MAGUS_ROD.get())).pattern(" DF").pattern(" VD").pattern("I  ").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('F'), (ItemLike)ModItems.FROZEN_CORE.get()).define(Character.valueOf('V'), DataComponentIngredient.of((boolean)true, (ItemStack)new ItemStack((ItemLike)ModItems.VOID_TEAR.get()))).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy(HAS_FROZEN_CORE_CRITERION, this.has((ItemLike)ModItems.FROZEN_CORE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.INFERNAL_CHALICE.get())).requires((ItemLike)ModItems.INFERNAL_CLAWS.get()).requires((ItemLike)ModItems.EMPEROR_CHALICE.get()).requires((ItemLike)ModItems.INFERNAL_TEAR.get()).requires((ItemLike)ModItems.MOLTEN_CORE.get()).unlockedBy("has_emperor_chalice", this.has((ItemLike)ModItems.EMPEROR_CHALICE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.INFERNAL_CLAWS.get())).requires((ItemLike)ModItems.INFERNAL_CLAW.get()).requires((ItemLike)ModItems.INFERNAL_CLAW.get()).requires((ItemLike)ModItems.INFERNAL_CLAW.get()).requires((ItemLike)ModItems.SLIME_PEARL.get()).unlockedBy(HAS_INFERNAL_CLAW_CRITERION, this.has((ItemLike)ModItems.INFERNAL_CLAW.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.INFERNAL_TEAR.get())).requires(DataComponentIngredient.of((boolean)true, (ItemStack)new ItemStack((ItemLike)ModItems.VOID_TEAR.get()))).requires((ItemLike)ModItems.WITCH_HAT.get()).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires((ItemLike)ModItems.INFERNAL_CLAW.get()).unlockedBy(HAS_INFERNAL_CLAW_CRITERION, this.has((ItemLike)ModItems.INFERNAL_CLAW.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.KRAKEN_SHELL.get())).requires((ItemLike)ModItems.KRAKEN_SHELL_FRAGMENT.get()).requires((ItemLike)ModItems.KRAKEN_SHELL_FRAGMENT.get()).requires((ItemLike)ModItems.KRAKEN_SHELL_FRAGMENT.get()).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).unlockedBy("has_kraken_shell_fragment", this.has((ItemLike)ModItems.KRAKEN_SHELL_FRAGMENT.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.LANTERN_OF_PARANOIA.get())).pattern("ISI").pattern("GMG").pattern(" I ").define(Character.valueOf('S'), (ItemLike)ModItems.SLIME_PEARL.get()).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('M'), (ItemLike)ModItems.MOLTEN_CORE.get()).unlockedBy(HAS_MOLTEN_CORE_CRITERION, this.has((ItemLike)ModItems.MOLTEN_CORE.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.MAGICBANE.get())).pattern("NG").pattern("IN").define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('N'), (ItemLike)ModItems.NEBULOUS_HEART.get()).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.MERCY_CROSS.get())).pattern("WGR").pattern("GLG").pattern("SGZ").define(Character.valueOf('W'), (ItemLike)ModItems.WITHERED_RIB.get()).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), (ItemLike)ModItems.RIB_BONE.get()).define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('S'), (ItemLike)Items.WITHER_SKELETON_SKULL).define(Character.valueOf('Z'), (ItemLike)ModItems.ZOMBIE_HEART.get()).unlockedBy(HAS_WITHERED_RIB_CRITERION, this.has((ItemLike)ModItems.WITHERED_RIB.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.MIDAS_TOUCHSTONE.get())).requires((ItemLike)Items.ANVIL).requires(Tags.Items.STORAGE_BLOCKS_GOLD).requires(Tags.Items.STORAGE_BLOCKS_GOLD).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).requires(DataComponentIngredient.of((boolean)true, (ItemStack)new ItemStack((ItemLike)ModItems.VOID_TEAR.get()))).unlockedBy(HAS_MOLTEN_CORE_CRITERION, this.has((ItemLike)ModItems.MOLTEN_CORE.get())).save(this.output);
        MobCharmRecipeBuilder.charmRecipe(this.items).pattern("FLF").pattern("FSF").pattern("F F").define(Character.valueOf('F'), (ItemLike)ModItems.MOB_CHARM_FRAGMENT.get()).define(Character.valueOf('L'), (TagKey<Item>)Tags.Items.LEATHERS).define(Character.valueOf('S'), (TagKey<Item>)Tags.Items.STRINGS).unlockedBy(HAS_MOB_CHARM_FRAGMENT_CRITERION, this.has((ItemLike)ModItems.MOB_CHARM_FRAGMENT.get())).save(this.output.withConditions(new ICondition[]{new CharmEnabledCondition()}));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.MOB_CHARM_BELT.get())).pattern("LLL").pattern("F F").pattern("FFF").define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('F'), (ItemLike)ModItems.MOB_CHARM_FRAGMENT.get()).unlockedBy(HAS_MOB_CHARM_FRAGMENT_CRITERION, this.has((ItemLike)ModItems.MOB_CHARM_FRAGMENT.get())).save(this.output.withConditions(new ICondition[]{new CharmEnabledCondition()}));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.PHOENIX_DOWN.get())).requires((ItemLike)ModItems.ANGELHEART_VIAL.get()).requires((ItemLike)ModItems.ANGELHEART_VIAL.get()).requires((ItemLike)ModItems.ANGELHEART_VIAL.get()).requires((ItemLike)ModItems.ANGELIC_FEATHER.get()).unlockedBy("has_angelic_feather", this.has((ItemLike)ModItems.ANGELIC_FEATHER.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.PYROMANCER_STAFF.get())).requires((ItemLike)ModItems.INFERNAL_CLAWS.get()).requires(Tags.Items.RODS_BLAZE).requires((ItemLike)ModItems.INFERNAL_TEAR.get()).requires((ItemLike)ModItems.SALAMANDER_EYE.get()).unlockedBy("has_infernal_claws", this.has((ItemLike)ModItems.INFERNAL_CLAWS.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.RENDING_GALE.get())).pattern(" BE").pattern("GVB").pattern("SG ").define(Character.valueOf('B'), (ItemLike)ModItems.BAT_WING.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('E'), (ItemLike)ModItems.EYE_OF_THE_STORM.get()).define(Character.valueOf('V'), DataComponentIngredient.of((boolean)true, (ItemStack)new ItemStack((ItemLike)ModItems.VOID_TEAR.get()))).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_eye_of_the_storm", this.has((ItemLike)ModItems.EYE_OF_THE_STORM.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ROD_OF_LYSSA.get())).requires((ItemLike)ModItems.INFERNAL_CLAW.get()).requires((ItemLike)ModItems.BAT_WING.get()).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).requires((ItemLike)Items.FISHING_ROD).unlockedBy(HAS_INFERNAL_CLAW_CRITERION, this.has((ItemLike)ModItems.INFERNAL_CLAW.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SALAMANDER_EYE.get())).requires((ItemLike)Items.ENDER_EYE).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires((ItemLike)ModItems.FROZEN_CORE.get()).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).unlockedBy(HAS_MOLTEN_CORE_CRITERION, this.has((ItemLike)ModItems.MOLTEN_CORE.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SERPENT_STAFF.get())).pattern(" CE").pattern(" KC").pattern("S  ").define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('C'), (ItemLike)ModItems.CHELICERAE.get()).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('K'), (ItemLike)ModItems.KRAKEN_SHELL_FRAGMENT.get()).unlockedBy("has_kraken_shell_fragment", this.has((ItemLike)ModItems.KRAKEN_SHELL_FRAGMENT.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SHEARS_OF_WINTER.get())).requires((ItemLike)ModItems.FROZEN_CORE.get()).requires((ItemLike)Items.SHEARS).requires(Tags.Items.GEMS_DIAMOND).requires(Tags.Items.GEMS_DIAMOND).unlockedBy(HAS_FROZEN_CORE_CRITERION, this.has((ItemLike)ModItems.FROZEN_CORE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SOJOURNER_STAFF.get())).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires(Tags.Items.INGOTS_GOLD).requires(Tags.Items.RODS_BLAZE).requires(DataComponentIngredient.of((boolean)true, (ItemStack)new ItemStack((ItemLike)ModItems.VOID_TEAR.get()))).unlockedBy(HAS_VOID_TEAR_CRITERION, this.has((ItemLike)ModItems.VOID_TEAR.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.TWILIGHT_CLOAK.get())).pattern("ICI").pattern("BCB").pattern("BCB").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), (ItemLike)Items.BLACK_WOOL).define(Character.valueOf('C'), (ItemLike)ModItems.CRIMSON_CLOTH.get()).unlockedBy("has_crimson_cloth", this.has((ItemLike)ModItems.CRIMSON_CLOTH.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.VOID_TEAR.get())).requires((ItemLike)Items.GHAST_TEAR).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).requires((ItemLike)ModItems.SLIME_PEARL.get()).requires(Tags.Items.GEMS_LAPIS).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.WITHERLESS_ROSE.get())).pattern("FNF").pattern("NRN").pattern("FNF").define(Character.valueOf('F'), (ItemLike)ModItems.FERTILE_ESSENCE.get()).define(Character.valueOf('N'), Tags.Items.NETHER_STARS).define(Character.valueOf('R'), (ItemLike)Items.ROSE_BUSH).unlockedBy(HAS_FERTILE_ESSENCE_CRITERION, this.has((ItemLike)ModItems.FERTILE_ESSENCE.get())).save(this.output);
    }

    private void registerUncraftingRecipes() {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLAZE_ROD, (int)4).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires((ItemLike)ModItems.MOLTEN_CORE.get()).unlockedBy(HAS_MOLTEN_CORE_CRITERION, this.has((ItemLike)ModItems.MOLTEN_CORE.get())).save(this.output, this.getRecipeKey("uncrafting/blaze_rod"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BONE, (int)5).requires((ItemLike)ModItems.RIB_BONE.get()).unlockedBy("has_rib_bone", this.has((ItemLike)ModItems.RIB_BONE.get())).save(this.output, this.getRecipeKey("uncrafting/bone"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ENDER_PEARL, (int)3).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(this.output, this.getRecipeKey("uncrafting/ender_pearl"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GHAST_TEAR).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).unlockedBy(HAS_CATALYZING_GLAND_CRITERIION, this.has((ItemLike)ModItems.CATALYZING_GLAND.get())).save(this.output, this.getRecipeKey("uncrafting/ghast_tear"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GLASS_BOTTLE, (int)6).pattern("W W").pattern(" W ").define(Character.valueOf('W'), (ItemLike)ModItems.WITCH_HAT.get()).unlockedBy(HAS_WITCH_HAT_CRITERION, this.has((ItemLike)ModItems.WITCH_HAT.get())).save(this.output, this.getRecipeKey("uncrafting/glass_bottle"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GLOWSTONE_DUST, (int)6).pattern("W  ").pattern("W  ").pattern(" W ").define(Character.valueOf('W'), (ItemLike)ModItems.WITCH_HAT.get()).unlockedBy(HAS_WITCH_HAT_CRITERION, this.has((ItemLike)ModItems.WITCH_HAT.get())).save(this.output, this.getRecipeKey("uncrafting/glowstone_dust"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET, (int)6).requires((ItemLike)ModItems.ZOMBIE_HEART.get()).requires((ItemLike)ModItems.ZOMBIE_HEART.get()).unlockedBy(HAS_ZOMBIE_HEART_CRITERION, this.has((ItemLike)ModItems.ZOMBIE_HEART.get())).save(this.output, this.getRecipeKey("uncrafting/gold_nugget"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GUNPOWDER, (int)6).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).unlockedBy(HAS_CATALYZING_GLAND_CRITERIION, this.has((ItemLike)ModItems.CATALYZING_GLAND.get())).save(this.output, this.getRecipeKey("uncrafting/gunpowder_creeper_gland"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GUNPOWDER, (int)10).requires((ItemLike)ModItems.EYE_OF_THE_STORM.get()).unlockedBy("has_eye_of_the_storm", this.has((ItemLike)ModItems.EYE_OF_THE_STORM.get())).save(this.output, this.getRecipeKey("uncrafting/gunpowder_storm_eye"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GUNPOWDER, (int)6).pattern("W  ").pattern(" W ").pattern("  W").define(Character.valueOf('W'), (ItemLike)ModItems.WITCH_HAT.get()).unlockedBy(HAS_WITCH_HAT_CRITERION, this.has((ItemLike)ModItems.WITCH_HAT.get())).save(this.output, this.getRecipeKey("uncrafting/gunpowder_witch_hat"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.INK_SAC, (int)6).requires((ItemLike)ModItems.SQUID_BEAK.get()).unlockedBy("has_squid_beak", this.has((ItemLike)ModItems.SQUID_BEAK.get())).save(this.output, this.getRecipeKey("uncrafting/ink_sac"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.MAGMA_CREAM, (int)3).requires((ItemLike)ModItems.MOLTEN_CORE.get()).unlockedBy(HAS_MOLTEN_CORE_CRITERION, this.has((ItemLike)ModItems.MOLTEN_CORE.get())).save(this.output, this.getRecipeKey("uncrafting/magma_cream"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PACKED_ICE).pattern("III").pattern("ICI").pattern("III").define(Character.valueOf('I'), (ItemLike)Items.ICE).define(Character.valueOf('C'), (ItemLike)ModItems.FROZEN_CORE.get()).unlockedBy(HAS_FROZEN_CORE_CRITERION, this.has((ItemLike)ModItems.FROZEN_CORE.get())).save(this.output, this.getRecipeKey("uncrafting/packed_ice"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PRISMARINE_CRYSTALS, (int)10).requires((ItemLike)ModItems.GUARDIAN_SPIKE.get()).requires((ItemLike)ModItems.GUARDIAN_SPIKE.get()).unlockedBy(HAS_GUARDIAN_SPIKE_CRITERION, this.has((ItemLike)ModItems.GUARDIAN_SPIKE.get())).save(this.output, this.getRecipeKey("uncrafting/prismarine_crystals"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PRISMARINE_SHARD, (int)5).requires((ItemLike)ModItems.GUARDIAN_SPIKE.get()).unlockedBy(HAS_GUARDIAN_SPIKE_CRITERION, this.has((ItemLike)ModItems.GUARDIAN_SPIKE.get())).save(this.output, this.getRecipeKey("uncrafting/prismarine_shard"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.REDSTONE, (int)6).pattern("W").pattern("W").pattern("W").define(Character.valueOf('W'), (ItemLike)ModItems.WITCH_HAT.get()).unlockedBy(HAS_WITCH_HAT_CRITERION, this.has((ItemLike)ModItems.WITCH_HAT.get())).save(this.output, this.getRecipeKey("uncrafting/redstone"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ROTTEN_FLESH, (int)6).requires((ItemLike)ModItems.ZOMBIE_HEART.get()).unlockedBy(HAS_ZOMBIE_HEART_CRITERION, this.has((ItemLike)ModItems.ZOMBIE_HEART.get())).save(this.output, this.getRecipeKey("uncrafting/rotten_flesh"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SLIME_BALL, (int)6).requires((ItemLike)ModItems.SLIME_PEARL.get()).unlockedBy(HAS_SLIME_PEARL_CRITERION, this.has((ItemLike)ModItems.SLIME_PEARL.get())).save(this.output, this.getRecipeKey("uncrafting/slime_ball"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SNOWBALL, (int)5).requires((ItemLike)ModItems.FROZEN_CORE.get()).unlockedBy(HAS_FROZEN_CORE_CRITERION, this.has((ItemLike)ModItems.FROZEN_CORE.get())).save(this.output, this.getRecipeKey("uncrafting/snowball"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SPIDER_EYE, (int)2).requires((ItemLike)ModItems.CHELICERAE.get()).requires((ItemLike)ModItems.CHELICERAE.get()).unlockedBy(HAS_CHELICERAE_CRITERION, this.has((ItemLike)ModItems.CHELICERAE.get())).save(this.output, this.getRecipeKey("uncrafting/spider_eye"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)4).requires((ItemLike)ModItems.WITCH_HAT.get()).unlockedBy(HAS_WITCH_HAT_CRITERION, this.has((ItemLike)ModItems.WITCH_HAT.get())).save(this.output, this.getRecipeKey("uncrafting/stick"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STRING, (int)6).requires((ItemLike)ModItems.CHELICERAE.get()).unlockedBy(HAS_CHELICERAE_CRITERION, this.has((ItemLike)ModItems.CHELICERAE.get())).save(this.output, this.getRecipeKey("uncrafting/string"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SUGAR, (int)6).pattern("WWW").define(Character.valueOf('W'), (ItemLike)ModItems.WITCH_HAT.get()).unlockedBy(HAS_WITCH_HAT_CRITERION, this.has((ItemLike)ModItems.WITCH_HAT.get())).save(this.output, this.getRecipeKey("uncrafting/sugar"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.WITHER_SKELETON_SKULL).requires((ItemLike)ModItems.WITHERED_RIB.get()).requires((ItemLike)ModItems.WITHERED_RIB.get()).requires((ItemLike)ModItems.WITHERED_RIB.get()).requires((ItemLike)Items.SKELETON_SKULL).unlockedBy(HAS_WITHERED_RIB_CRITERION, this.has((ItemLike)ModItems.WITHERED_RIB.get())).save(this.output, this.getRecipeKey("uncrafting/wither_skeleton_skull"));
        ResourceKey<Recipe<?>> spawnEggId = this.getRecipeKey("uncrafting/spawn_egg");
        SpawnEggRecipeBuilder.spawnEggRecipe().addIngredient((ItemLike)ModItems.MOB_CHARM_FRAGMENT.get()).addIngredient((ItemLike)ModItems.MOB_CHARM_FRAGMENT.get()).addIngredient((ItemLike)Items.EGG).unlockedBy(HAS_MOB_CHARM_FRAGMENT_CRITERION, this.has((ItemLike)ModItems.MOB_CHARM_FRAGMENT.get())).build(this.output.withConditions(new ICondition[]{new SpawnEggEnabledCondition(), new CharmEnabledCondition()}), spawnEggId);
    }

    private void registerHandgunRecipes(RecipeOutput recipeOutput) {
        RecipeOutput conditionalHandgunRecipeOutput = recipeOutput.withConditions(new ICondition[]{new HandgunEnabledCondition()});
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.HANDGUN.get())).pattern("BIM").pattern("ISI").pattern("IGI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), (ItemLike)ModItems.BARREL_ASSEMBLY.get()).define(Character.valueOf('M'), (ItemLike)ModItems.HAMMER_ASSEMBLY.get()).define(Character.valueOf('G'), (ItemLike)ModItems.GRIP_ASSEMBLY.get()).define(Character.valueOf('S'), (ItemLike)ModItems.SLIME_PEARL.get()).unlockedBy("has_barrel_assembly", this.has((ItemLike)ModItems.BARREL_ASSEMBLY.get())).save(conditionalHandgunRecipeOutput);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BARREL_ASSEMBLY.get())).pattern("III").pattern("EME").pattern("III").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('E'), (ItemLike)ModItems.NEBULOUS_HEART.get()).define(Character.valueOf('M'), (ItemLike)Items.MAGMA_CREAM).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(conditionalHandgunRecipeOutput);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GRIP_ASSEMBLY.get())).pattern("III").pattern("IMI").pattern("ICI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), (ItemLike)ModItems.EMPTY_MAGAZINE.get()).define(Character.valueOf('M'), (ItemLike)Items.MAGMA_CREAM).unlockedBy("has_magma_cream", this.has((ItemLike)Items.MAGMA_CREAM)).save(conditionalHandgunRecipeOutput);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.EMPTY_MAGAZINE.get())).pattern("I I").pattern("IGI").pattern("SIS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).unlockedBy("has_iron_ingot", this.has((ItemLike)Items.IRON_INGOT)).save(conditionalHandgunRecipeOutput);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.HAMMER_ASSEMBLY.get())).pattern("IIB").pattern("RMI").pattern("III").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), (ItemLike)Items.STONE_BUTTON).define(Character.valueOf('R'), Tags.Items.RODS_BLAZE).define(Character.valueOf('M'), (ItemLike)ModItems.MOLTEN_CORE.get()).unlockedBy(HAS_MOLTEN_CORE_CRITERION, this.has((ItemLike)ModItems.MOLTEN_CORE.get())).save(conditionalHandgunRecipeOutput);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BLAZE_BULLET.get()), (int)8).requires((ItemLike)Items.BLAZE_POWDER).requires(Tags.Items.RODS_BLAZE).requires(Tags.Items.NUGGETS_GOLD).requires(Tags.Items.NUGGETS_GOLD).unlockedBy("has_blaze_rod", this.has((ItemLike)Items.BLAZE_ROD)).save(conditionalHandgunRecipeOutput);
        this.addBulletPotionRecipe(conditionalHandgunRecipeOutput, ModItems.BLAZE_BULLET.get());
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BUSTER_BULLET.get()), (int)8).requires((ItemLike)ModItems.CONCUSSIVE_BULLET.get()).requires((ItemLike)ModItems.CONCUSSIVE_BULLET.get()).requires((ItemLike)ModItems.CONCUSSIVE_BULLET.get()).requires((ItemLike)ModItems.CONCUSSIVE_BULLET.get()).requires((ItemLike)ModItems.CONCUSSIVE_BULLET.get()).requires((ItemLike)ModItems.CONCUSSIVE_BULLET.get()).requires((ItemLike)ModItems.CONCUSSIVE_BULLET.get()).requires((ItemLike)ModItems.CONCUSSIVE_BULLET.get()).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).unlockedBy("has_concussive_bullet", this.has((ItemLike)ModItems.CONCUSSIVE_BULLET.get())).save(conditionalHandgunRecipeOutput);
        this.addBulletPotionRecipe(recipeOutput, ModItems.BUSTER_BULLET.get());
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CONCUSSIVE_BULLET.get()), (int)8).requires(Tags.Items.SLIME_BALLS).requires(Tags.Items.NUGGETS_GOLD).requires(Tags.Items.NUGGETS_GOLD).requires(Tags.Items.GUNPOWDERS).unlockedBy(HAS_GUNPOWDER_CRITERION, this.has((ItemLike)Items.GUNPOWDER)).save(conditionalHandgunRecipeOutput);
        this.addBulletPotionRecipe(recipeOutput, ModItems.CONCUSSIVE_BULLET.get());
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ENDER_BULLET.get()), (int)8).requires((ItemLike)ModItems.SEEKER_BULLET.get()).requires((ItemLike)ModItems.SEEKER_BULLET.get()).requires((ItemLike)ModItems.SEEKER_BULLET.get()).requires((ItemLike)ModItems.SEEKER_BULLET.get()).requires((ItemLike)ModItems.SEEKER_BULLET.get()).requires((ItemLike)ModItems.SEEKER_BULLET.get()).requires((ItemLike)ModItems.SEEKER_BULLET.get()).requires((ItemLike)ModItems.SEEKER_BULLET.get()).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).unlockedBy("has_seeker_bullet", this.has((ItemLike)ModItems.SEEKER_BULLET.get())).save(conditionalHandgunRecipeOutput);
        this.addBulletPotionRecipe(recipeOutput, ModItems.ENDER_BULLET.get());
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.EXORCISM_BULLET.get()), (int)8).requires((ItemLike)ModItems.NEUTRAL_BULLET.get()).requires((ItemLike)ModItems.NEUTRAL_BULLET.get()).requires((ItemLike)ModItems.NEUTRAL_BULLET.get()).requires((ItemLike)ModItems.NEUTRAL_BULLET.get()).requires((ItemLike)ModItems.NEUTRAL_BULLET.get()).requires((ItemLike)ModItems.NEUTRAL_BULLET.get()).requires((ItemLike)ModItems.NEUTRAL_BULLET.get()).requires((ItemLike)ModItems.NEUTRAL_BULLET.get()).requires((ItemLike)ModItems.ZOMBIE_HEART.get()).unlockedBy("has_neutral_bullet", this.has((ItemLike)ModItems.NEUTRAL_BULLET.get())).save(conditionalHandgunRecipeOutput);
        this.addBulletPotionRecipe(recipeOutput, ModItems.EXORCISM_BULLET.get());
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.NEUTRAL_BULLET.get()), (int)8).requires((ItemLike)Items.FLINT).requires(Tags.Items.NUGGETS_GOLD).requires(Tags.Items.NUGGETS_GOLD).requires(Tags.Items.GUNPOWDERS).unlockedBy(HAS_GUNPOWDER_CRITERION, this.has((ItemLike)Items.GUNPOWDER)).save(conditionalHandgunRecipeOutput);
        this.addBulletPotionRecipe(conditionalHandgunRecipeOutput, ModItems.NEUTRAL_BULLET.get());
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SAND_BULLET.get()), (int)8).requires(Tags.Items.SANDSTONE_BLOCKS).requires(Tags.Items.SLIME_BALLS).requires(Tags.Items.NUGGETS_GOLD).requires(Tags.Items.GUNPOWDERS).unlockedBy(HAS_GUNPOWDER_CRITERION, this.has((ItemLike)Items.GUNPOWDER)).save(conditionalHandgunRecipeOutput);
        this.addBulletPotionRecipe(recipeOutput, ModItems.SAND_BULLET.get());
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SEEKER_BULLET.get()), (int)8).requires(Tags.Items.GEMS_LAPIS).requires(Tags.Items.NUGGETS_GOLD).requires(Tags.Items.NUGGETS_GOLD).requires(Tags.Items.GUNPOWDERS).unlockedBy(HAS_GUNPOWDER_CRITERION, this.has((ItemLike)Items.GUNPOWDER)).save(conditionalHandgunRecipeOutput);
        this.addBulletPotionRecipe(conditionalHandgunRecipeOutput, ModItems.SEEKER_BULLET.get());
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.STORM_BULLET.get()), (int)8).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).requires(Tags.Items.NUGGETS_GOLD).requires(Tags.Items.NUGGETS_GOLD).requires(Tags.Items.GUNPOWDERS).unlockedBy(HAS_GUNPOWDER_CRITERION, this.has((ItemLike)Items.GUNPOWDER)).save(conditionalHandgunRecipeOutput);
        this.addBulletPotionRecipe(recipeOutput, ModItems.STORM_BULLET.get());
        this.addMagazineRecipe(recipeOutput, ModItems.BLAZE_BULLET.get(), ModItems.BLAZE_MAGAZINE.get());
        this.addMagazineRecipe(recipeOutput, ModItems.BUSTER_BULLET.get(), ModItems.BUSTER_MAGAZINE.get());
        this.addMagazineRecipe(recipeOutput, ModItems.CONCUSSIVE_BULLET.get(), ModItems.CONCUSSIVE_MAGAZINE.get());
        this.addMagazineRecipe(recipeOutput, ModItems.ENDER_BULLET.get(), ModItems.ENDER_MAGAZINE.get());
        this.addMagazineRecipe(recipeOutput, ModItems.EXORCISM_BULLET.get(), ModItems.EXORCISM_MAGAZINE.get());
        this.addMagazineRecipe(recipeOutput, ModItems.NEUTRAL_BULLET.get(), ModItems.NEUTRAL_MAGAZINE.get());
        this.addMagazineRecipe(recipeOutput, ModItems.SAND_BULLET.get(), ModItems.SAND_MAGAZINE.get());
        this.addMagazineRecipe(recipeOutput, ModItems.SEEKER_BULLET.get(), ModItems.SEEKER_MAGAZINE.get());
        this.addMagazineRecipe(recipeOutput, ModItems.STORM_BULLET.get(), ModItems.STORM_MAGAZINE.get());
    }

    private void registerAlkahestryRecipes(RecipeOutput recipeOutput) {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ALKAHESTRY_TOME.get())).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires((ItemLike)ModItems.WITCH_HAT.get()).requires((ItemLike)ModItems.EYE_OF_THE_STORM.get()).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).requires((ItemLike)Items.BOOK).requires((ItemLike)ModItems.SLIME_PEARL.get()).requires((ItemLike)ModItems.CHELICERAE.get()).requires((ItemLike)Items.WITHER_SKELETON_SKULL).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).unlockedBy(HAS_WITCH_HAT_CRITERION, this.has((ItemLike)ModItems.WITCH_HAT.get())).save(recipeOutput.withConditions(new ICondition[]{new AlkahestryEnabledCondition()}));
        ChargingRecipeBuilder.chargingRecipe((ItemLike)Items.GLOWSTONE_DUST, 1).build(recipeOutput, RegistryHelper.getRegistryName(Items.GLOWSTONE_DUST));
        ChargingRecipeBuilder.chargingRecipe((ItemLike)Items.GLOWSTONE, 4).build(recipeOutput, RegistryHelper.getRegistryName(Items.GLOWSTONE));
        ChargingRecipeBuilder.chargingRecipe((ItemLike)Items.REDSTONE, 1).build(recipeOutput, RegistryHelper.getRegistryName(Items.REDSTONE));
        ChargingRecipeBuilder.chargingRecipe((ItemLike)Items.REDSTONE_BLOCK, 9).build(recipeOutput, RegistryHelper.getRegistryName(Items.REDSTONE_BLOCK));
        DrainRecipeBuilder.drainRecipe((ItemLike)Items.REDSTONE, 1).build(recipeOutput, RegistryHelper.getRegistryName(Items.REDSTONE));
        CraftingRecipeBuilder.craftingRecipe((ItemLike)Items.CHARCOAL, 4, 5).save(recipeOutput, this.getRecipeKey(Items.CHARCOAL));
        CraftingRecipeBuilder.craftingRecipe((ItemLike)Items.CLAY, 4, 3).save(recipeOutput, this.getRecipeKey(Items.CLAY));
        CraftingRecipeBuilder.craftingRecipe(this.items, INGOTS_COPPER, 8, 5).save(recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(INGOTS_COPPER))}), ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)"copper_ingot")));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 64, 2).save(recipeOutput, this.getRecipeKey(Items.DIAMOND));
        CraftingRecipeBuilder.craftingRecipe((ItemLike)Items.DIRT, 4, 33).save(recipeOutput, this.getRecipeKey(Items.DIRT));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.GEMS_EMERALD, 32, 2).save(recipeOutput, this.getRecipeKey(Items.EMERALD));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.END_STONES, 8, 17).save(recipeOutput, this.getRecipeKey(Items.END_STONE));
        CraftingRecipeBuilder.craftingRecipe((ItemLike)Items.FLINT, 8, 9).save(recipeOutput, this.getRecipeKey(Items.FLINT));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.INGOTS_GOLD, 32, 2).save(recipeOutput, this.getRecipeKey(Items.GOLD_INGOT));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.GRAVELS, 4, 17).save(recipeOutput, this.getRecipeKey(Items.GRAVEL));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.GUNPOWDERS, 8, 3).save(recipeOutput, this.getRecipeKey(Items.GUNPOWDER));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.INGOTS_IRON, 32, 2).save(recipeOutput, this.getRecipeKey(Items.IRON_INGOT));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.GEMS_LAPIS, 4, 2).save(recipeOutput, this.getRecipeKey(Items.LAPIS_LAZULI));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.NETHER_STARS, 256, 2).save(recipeOutput, this.getRecipeKey(Items.NETHER_STAR));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.NETHERRACKS, 4, 9).save(recipeOutput, this.getRecipeKey(Items.NETHERRACK));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.OBSIDIANS, 8, 5).save(recipeOutput, this.getRecipeKey(Items.OBSIDIAN));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.SANDS, 4, 33).save(recipeOutput, this.getRecipeKey(Items.SAND));
        CraftingRecipeBuilder.craftingRecipe(this.items, (TagKey<Item>)Tags.Items.SANDSTONE_BLOCKS, 4, 9).save(recipeOutput, this.getRecipeKey(Items.SANDSTONE));
        CraftingRecipeBuilder.craftingRecipe(this.items, INGOTS_SILVER, 32, 2).save(recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(INGOTS_SILVER))}), ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)"silver_ingot")));
        CraftingRecipeBuilder.craftingRecipe((ItemLike)Items.SOUL_SAND, 8, 9).save(recipeOutput, this.getRecipeKey(Items.SOUL_SAND));
        CraftingRecipeBuilder.craftingRecipe(this.items, INGOTS_STEEL, 32, 2).save(recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(INGOTS_STEEL))}), ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)"steel_ingot")));
        CraftingRecipeBuilder.craftingRecipe(this.items, INGOTS_TIN, 32, 2).save(recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(INGOTS_TIN))}), ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)"tin_ingot")));
    }

    private ResourceKey<Recipe<?>> getRecipeKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Reliquary.getRL(name));
    }

    private ResourceKey<Recipe<?>> getRecipeKey(Item item) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)item));
    }

    private void registerPotionRecipes(RecipeOutput recipeOutput) {
        RecipeOutput potionsEnabledRecipeOutput = recipeOutput.withConditions(new ICondition[]{new PotionsEnabledCondition()});
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.EMPTY_POTION_VIAL.get())).pattern("G G").pattern("G G").pattern(" G ").define(Character.valueOf('G'), Tags.Items.GLASS_PANES).unlockedBy("has_glass_pane", this.has((ItemLike)Items.GLASS_PANE)).save(potionsEnabledRecipeOutput);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.APHRODITE_POTION.get())).pattern("GBG").pattern("GFG").pattern("RGC").define(Character.valueOf('G'), Tags.Items.GLASS_PANES).define(Character.valueOf('B'), (ItemLike)Items.WATER_BUCKET).define(Character.valueOf('F'), (ItemLike)ModItems.FERTILE_ESSENCE.get()).define(Character.valueOf('R'), Tags.Items.DYES_RED).define(Character.valueOf('C'), (ItemLike)Items.COCOA_BEANS).unlockedBy(HAS_FERTILE_ESSENCE_CRITERION, this.has((ItemLike)ModItems.FERTILE_ESSENCE.get())).save(potionsEnabledRecipeOutput);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.FERTILE_POTION.get())).pattern("GBG").pattern("GFG").pattern("CGY").define(Character.valueOf('G'), Tags.Items.GLASS_PANES).define(Character.valueOf('B'), (ItemLike)Items.WATER_BUCKET).define(Character.valueOf('F'), (ItemLike)ModItems.FERTILE_ESSENCE.get()).define(Character.valueOf('C'), Tags.Items.DYES_GREEN).define(Character.valueOf('Y'), Tags.Items.DYES_YELLOW).unlockedBy(HAS_FERTILE_ESSENCE_CRITERION, this.has((ItemLike)ModItems.FERTILE_ESSENCE.get())).save(potionsEnabledRecipeOutput);
        this.addItemPotionRecipe(potionsEnabledRecipeOutput, Items.ARROW, (Item)ModItems.TIPPED_ARROW.get(), 0.125f, 'A', false);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.APOTHECARY_CAULDRON_ITEM.get())).pattern("GNG").pattern("ICI").pattern("NMN").define(Character.valueOf('G'), (ItemLike)ModItems.CATALYZING_GLAND.get()).define(Character.valueOf('N'), (ItemLike)ModItems.NEBULOUS_HEART.get()).define(Character.valueOf('I'), (ItemLike)ModItems.INFERNAL_CLAW.get()).define(Character.valueOf('C'), (ItemLike)Items.CAULDRON).define(Character.valueOf('M'), (ItemLike)ModItems.MOLTEN_CORE.get()).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(potionsEnabledRecipeOutput);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.APOTHECARY_MORTAR_ITEM.get())).pattern("GNG").pattern("NGN").pattern("NNN").define(Character.valueOf('G'), (ItemLike)ModItems.CATALYZING_GLAND.get()).define(Character.valueOf('N'), (ItemLike)Items.QUARTZ_BLOCK).unlockedBy(HAS_CATALYZING_GLAND_CRITERIION, this.has((ItemLike)ModItems.CATALYZING_GLAND.get())).save(potionsEnabledRecipeOutput);
    }

    private void registerPedestalRecipes(RecipeOutput recipeOutput) {
        this.addPassivePedestalRecipe(recipeOutput, Items.WHITE_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.WHITE).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.ORANGE_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.ORANGE).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.MAGENTA_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.MAGENTA).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.LIGHT_BLUE_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.LIGHT_BLUE).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.YELLOW_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.YELLOW).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.LIME_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.LIME).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.PINK_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.PINK).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.GRAY_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.GRAY).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.LIGHT_GRAY_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.LIGHT_GRAY).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.CYAN_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.CYAN).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.PURPLE_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.PURPLE).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.BLUE_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.BLUE).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.BROWN_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.BROWN).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.GREEN_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.GREEN).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.RED_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.RED).get());
        this.addPassivePedestalRecipe(recipeOutput, Items.BLACK_CARPET, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.BLACK).get());
        for (DyeColor color : DyeColor.values()) {
            this.addPedestalRecipe(recipeOutput, ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(color).get(), ModBlocks.PEDESTAL_ITEMS.get(color).get());
        }
    }

    private void registerCraftableMobDropRecipes() {
        this.addCraftableMobDropRecipe(this.output, ModItems.BAT_WING.get(), builder -> builder.pattern("GGG").pattern("GFG").pattern("GGG").define(Character.valueOf('F'), Tags.Items.FEATHERS).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_feather", this.hasTag((TagKey<Item>)Tags.Items.FEATHERS)));
        this.addCraftableMobDropRecipe(this.output, ModItems.CATALYZING_GLAND.get(), builder -> builder.pattern("GGG").pattern("GPG").pattern("GGG").define(Character.valueOf('P'), Tags.Items.GUNPOWDERS).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy(HAS_GUNPOWDER_CRITERION, this.hasTag((TagKey<Item>)Tags.Items.GUNPOWDERS)));
        this.addCraftableMobDropRecipe(this.output, ModItems.CHELICERAE.get(), builder -> builder.pattern("GGG").pattern("GSG").pattern("GGG").define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_string", this.hasTag((TagKey<Item>)Tags.Items.STRINGS)));
        this.addCraftableMobDropRecipe(this.output, ModItems.FROZEN_CORE.get(), builder -> builder.pattern("GPG").pattern("GSG").pattern("GSG").define(Character.valueOf('P'), (ItemLike)Items.PUMPKIN).define(Character.valueOf('S'), (ItemLike)Items.SNOW).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_snow", this.has((ItemLike)Items.SNOW)));
        this.addCraftableMobDropRecipe(this.output, ModItems.GUARDIAN_SPIKE.get(), builder -> builder.pattern("GGG").pattern("GPG").pattern("GGG").define(Character.valueOf('P'), (ItemLike)Items.PRISMARINE_SHARD).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_prismarine", this.has((ItemLike)Items.PRISMARINE_SHARD)));
        this.addCraftableMobDropRecipe(this.output, ModItems.MOLTEN_CORE.get(), builder -> builder.pattern("GGG").pattern("GMG").pattern("GGG").define(Character.valueOf('M'), (ItemLike)Items.MAGMA_CREAM).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_magma_cream", this.has((ItemLike)Items.MAGMA_CREAM)));
        this.addCraftableMobDropRecipe(this.output, ModItems.NEBULOUS_HEART.get(), builder -> builder.pattern("GGG").pattern("GEG").pattern("GGG").define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_ender_pearl", this.hasTag((TagKey<Item>)Tags.Items.ENDER_PEARLS)));
        this.addCraftableMobDropRecipe(this.output, ModItems.RIB_BONE.get(), builder -> builder.pattern("III").pattern("IBI").pattern("III").define(Character.valueOf('B'), Tags.Items.BONES).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("has_bone", this.hasTag((TagKey<Item>)Tags.Items.BONES)));
        this.addCraftableMobDropRecipe(this.output, ModItems.SLIME_PEARL.get(), builder -> builder.pattern("III").pattern("ISI").pattern("III").define(Character.valueOf('S'), Tags.Items.SLIME_BALLS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("has_slimeball", this.hasTag((TagKey<Item>)Tags.Items.SLIME_BALLS)));
        this.addCraftableMobDropRecipe(this.output, ModItems.SQUID_BEAK.get(), builder -> builder.pattern("GGG").pattern("GIG").pattern("GGG").define(Character.valueOf('I'), (ItemLike)Items.INK_SAC).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_ink_sac", this.has((ItemLike)Items.INK_SAC)));
        this.addCraftableMobDropRecipe(this.output, ModItems.EYE_OF_THE_STORM.get(), builder -> builder.pattern("GGG").pattern("GCG").pattern("GGG").define(Character.valueOf('C'), (ItemLike)ModItems.CATALYZING_GLAND.get()).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy(HAS_CATALYZING_GLAND_CRITERIION, this.has((ItemLike)ModItems.CATALYZING_GLAND.get())));
        this.addCraftableMobDropRecipe(this.output, ModItems.WITHERED_RIB.get(), builder -> builder.pattern("D D").pattern(" S ").pattern("D D").define(Character.valueOf('S'), (ItemLike)Items.SKELETON_SKULL).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).unlockedBy("has_skeleton_skull", this.has((ItemLike)Items.SKELETON_SKULL)));
        this.addCraftableMobDropRecipe(this.output, ModItems.ZOMBIE_HEART.get(), builder -> builder.pattern("III").pattern("IFI").pattern("III").define(Character.valueOf('F'), (ItemLike)Items.ROTTEN_FLESH).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("has_rotten_flesh", this.has((ItemLike)Items.ROTTEN_FLESH)));
        this.addCraftableMobDropRecipe(this.output, (Item)ModItems.WITCH_HAT.get(), builder -> builder.pattern("SLS").pattern("RGR").pattern("TLT").define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('L'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('T'), (ItemLike)Items.STICK).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_glowstone", this.has(Tags.Items.DUSTS_GLOWSTONE)));
    }

    private void registerIngredientRecipes() {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CRIMSON_CLOTH.get())).requires((ItemLike)Items.RED_WOOL).requires((ItemLike)Items.BLACK_WOOL).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).requires((ItemLike)ModItems.NEBULOUS_HEART.get()).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.FERTILE_ESSENCE.get())).requires((ItemLike)ModItems.RIB_BONE.get()).requires((ItemLike)ModItems.CATALYZING_GLAND.get()).requires(Tags.Items.DYES_GREEN).requires((ItemLike)ModItems.SLIME_PEARL.get()).unlockedBy(HAS_SLIME_PEARL_CRITERION, this.has((ItemLike)ModItems.SLIME_PEARL.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.INFERNAL_CLAW.get())).requires(Tags.Items.LEATHERS).requires((ItemLike)ModItems.MOLTEN_CORE.get()).requires((ItemLike)ModItems.RIB_BONE.get()).requires((ItemLike)ModItems.SLIME_PEARL.get()).unlockedBy(HAS_SLIME_PEARL_CRITERION, this.has((ItemLike)ModItems.SLIME_PEARL.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.KRAKEN_SHELL_FRAGMENT.get())).requires((ItemLike)ModItems.SQUID_BEAK.get()).requires((ItemLike)ModItems.SQUID_BEAK.get()).requires((ItemLike)ModItems.SQUID_BEAK.get()).requires((ItemLike)ModItems.SLIME_PEARL.get()).unlockedBy("has_squid_beak", this.has((ItemLike)ModItems.SQUID_BEAK.get())).save(this.output);
    }

    private void registerCharmFragmentRecipes() {
        RecipeOutput conditionalRecipeOutput = this.output.withConditions(new ICondition[]{new CharmEnabledCondition()});
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.BLAZE)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.MOLTEN_CORE.get()).define(Character.valueOf('S'), Tags.Items.RODS_BLAZE).define(Character.valueOf('T'), (ItemLike)Items.BLAZE_POWDER).unlockedBy(HAS_MOLTEN_CORE_CRITERION, this.has((ItemLike)ModItems.MOLTEN_CORE.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/blaze"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.CAVE_SPIDER)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.CHELICERAE.get()).define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('T'), DataComponentIngredient.of((boolean)true, (ItemStack)PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.POISON))).unlockedBy(HAS_CHELICERAE_CRITERION, this.has((ItemLike)ModItems.CHELICERAE.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/cave_spider"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.CREEPER)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.CATALYZING_GLAND.get()).define(Character.valueOf('S'), Tags.Items.GUNPOWDERS).define(Character.valueOf('T'), (ItemLike)Items.BONE).unlockedBy(HAS_CATALYZING_GLAND_CRITERIION, this.has((ItemLike)ModItems.CATALYZING_GLAND.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/creeper"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.ENDERMAN)).pattern("PPP").pattern("SPS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.NEBULOUS_HEART.get()).define(Character.valueOf('S'), Tags.Items.ENDER_PEARLS).unlockedBy(HAS_NEBULOUS_HEART_CRITERION, this.has((ItemLike)ModItems.NEBULOUS_HEART.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/enderman"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.GHAST)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('S'), Tags.Items.GUNPOWDERS).define(Character.valueOf('T'), (ItemLike)ModItems.CATALYZING_GLAND.get()).unlockedBy(HAS_CATALYZING_GLAND_CRITERIION, this.has((ItemLike)ModItems.CATALYZING_GLAND.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/ghast"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.GUARDIAN)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.GUARDIAN_SPIKE.get()).define(Character.valueOf('S'), (ItemLike)Items.PRISMARINE_SHARD).define(Character.valueOf('T'), (ItemLike)Items.COD).unlockedBy(HAS_GUARDIAN_SPIKE_CRITERION, this.has((ItemLike)ModItems.GUARDIAN_SPIKE.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/guardian"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.MAGMA_CUBE)).pattern("PPP").pattern("SSS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.MOLTEN_CORE.get()).define(Character.valueOf('S'), (ItemLike)Items.MAGMA_CREAM).unlockedBy(HAS_MOLTEN_CORE_CRITERION, this.has((ItemLike)ModItems.MOLTEN_CORE.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/magma_cube"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.SKELETON)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.RIB_BONE.get()).define(Character.valueOf('S'), (ItemLike)Items.BONE).define(Character.valueOf('T'), (ItemLike)Items.FLINT).unlockedBy("has_rib_bone", this.has((ItemLike)ModItems.RIB_BONE.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/skeleton"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.SLIME)).pattern("PPP").pattern("SSS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.SLIME_PEARL.get()).define(Character.valueOf('S'), Tags.Items.SLIME_BALLS).unlockedBy(HAS_SLIME_PEARL_CRITERION, this.has((ItemLike)ModItems.SLIME_PEARL.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/slime"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.SPIDER)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.CHELICERAE.get()).define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('T'), (ItemLike)Items.SPIDER_EYE).unlockedBy(HAS_CHELICERAE_CRITERION, this.has((ItemLike)ModItems.CHELICERAE.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/spider"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.WITCH)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.WITCH_HAT.get()).define(Character.valueOf('S'), (ItemLike)Items.GLASS_BOTTLE).define(Character.valueOf('T'), (ItemLike)Items.SPIDER_EYE).unlockedBy(HAS_WITCH_HAT_CRITERION, this.has((ItemLike)ModItems.WITCH_HAT.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/witch"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.WITHER_SKELETON)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.WITHERED_RIB.get()).define(Character.valueOf('S'), (ItemLike)Items.BONE).define(Character.valueOf('T'), (ItemLike)Items.WITHER_SKELETON_SKULL).unlockedBy(HAS_WITHERED_RIB_CRITERION, this.has((ItemLike)ModItems.WITHERED_RIB.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/wither_skeleton"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.ZOMBIE)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.ZOMBIE_HEART.get()).define(Character.valueOf('S'), (ItemLike)Items.ROTTEN_FLESH).define(Character.valueOf('T'), (ItemLike)Items.BONE).unlockedBy(HAS_ZOMBIE_HEART_CRITERION, this.has((ItemLike)ModItems.ZOMBIE_HEART.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/zombie"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(EntityType.ZOMBIFIED_PIGLIN)).pattern("PPP").pattern("STS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModItems.ZOMBIE_HEART.get()).define(Character.valueOf('S'), (ItemLike)Items.ROTTEN_FLESH).define(Character.valueOf('T'), (ItemLike)Items.GOLDEN_SWORD).unlockedBy(HAS_ZOMBIE_HEART_CRITERION, this.has((ItemLike)ModItems.ZOMBIE_HEART.get())).save(conditionalRecipeOutput, this.getRecipeKey("mob_charm_fragments/zombified_piglin"));
    }

    private Criterion<?> hasTag(TagKey<Item> tag) {
        return ReliquaryRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(this.items, tag).build()});
    }

    private void addCraftableMobDropRecipe(RecipeOutput recipeOutput, Item item, Consumer<ShapedRecipeBuilder> setRecipe) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)item);
        setRecipe.accept(builder);
        builder.save(recipeOutput.withConditions(new ICondition[]{new MobDropsCraftableCondition()}), this.getRecipeKey(item));
    }

    private void addPedestalRecipe(RecipeOutput recipeOutput, BlockItem passivePedestalItem, BlockItem pedestalItem) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)pedestalItem).pattern("D D").pattern(" P ").pattern("D D").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('P'), (ItemLike)passivePedestalItem).unlockedBy("has_passive_pedestal", this.has((ItemLike)ModBlocks.PASSIVE_PEDESTAL_ITEMS.get(DyeColor.WHITE).get())).save(recipeOutput.withConditions(new ICondition[]{new PedestalEnabledCondition()}));
    }

    private void addPassivePedestalRecipe(RecipeOutput recipeOutput, Item carpetItem, BlockItem pedestalItem) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)pedestalItem).pattern(" C ").pattern("GQG").pattern("SSS").define(Character.valueOf('C'), (ItemLike)carpetItem).define(Character.valueOf('G'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ_BLOCK).define(Character.valueOf('S'), (ItemLike)Items.QUARTZ_SLAB).unlockedBy("has_quartz_block", this.has((ItemLike)Items.QUARTZ_BLOCK)).save(recipeOutput.withConditions(new ICondition[]{new PassivePedestalEnabledCondition()}));
    }

    private void addBulletPotionRecipe(RecipeOutput recipeOutput, Item item) {
        this.addItemPotionRecipe(recipeOutput, item, item, 0.2f, 'B', true);
    }

    private void addItemPotionRecipe(RecipeOutput recipeOutput, Item itemIngredient, Item item, float durationFactor, char itemKey, boolean includeSuffix) {
        ResourceLocation registryName = RegistryHelper.getRegistryName(item);
        String path = registryName.getPath();
        ResourceLocation id = includeSuffix ? ResourceLocation.fromNamespaceAndPath((String)registryName.getNamespace(), (String)(registryName.getPath() + "_potion")) : registryName;
        PotionEffectsRecipeBuilder.potionEffectsRecipe((ItemLike)item, 8, durationFactor).pattern(String.valueOf(itemKey) + itemKey + itemKey).pattern(itemKey + "P" + itemKey).pattern(String.valueOf(itemKey) + itemKey + itemKey).define(Character.valueOf(itemKey), (ItemLike)itemIngredient).define(Character.valueOf('P'), (ItemLike)ModItems.LINGERING_POTION.get()).unlockedBy("has_" + (path.lastIndexOf(47) > -1 ? path.substring(path.indexOf(47) + 1) : path), this.has((ItemLike)item)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)id));
    }

    private void addMagazineRecipe(RecipeOutput recipeOutput, BulletItem bulletItem, MagazineItem magazineItem) {
        String path = this.getRecipeKey(bulletItem).location().getPath();
        PotionEffectsRecipeBuilder.potionEffectsRecipe((ItemLike)magazineItem, 1, 1.0f).pattern("BBB").pattern("BMB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)bulletItem).define(Character.valueOf('M'), (ItemLike)ModItems.EMPTY_MAGAZINE.get()).unlockedBy("has_" + (path.lastIndexOf(47) > -1 ? path.substring(path.indexOf(47) + 1) : path), this.has((ItemLike)bulletItem)).save(recipeOutput, this.getRecipeKey(magazineItem));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        protected Runner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
            super(packOutput, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            return new ReliquaryRecipeProvider(provider, recipeOutput);
        }

        public String getName() {
            return "Reliquary Recipes";
        }
    }
}

