/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;

public class ReliquaryFakePlayer
extends FakePlayer {
    private final NonNullList<ItemStack> fakePlayerHandInventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private static final String FAKE_PLAYER_USERNAME = "reliquary_pedestal_fake_player";

    public ReliquaryFakePlayer(ServerLevel level) {
        this(level, new GameProfile(UUID.nameUUIDFromBytes(FAKE_PLAYER_USERNAME.getBytes()), FAKE_PLAYER_USERNAME));
    }

    private ReliquaryFakePlayer(ServerLevel level, GameProfile name) {
        super(level, name);
    }

    public void tick() {
        if (this.level().isClientSide) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            AttributeMap attributeMap;
            EquipmentSlot equipmentSlot = EquipmentSlot.values()[i];
            ItemStack oldStack = (ItemStack)this.fakePlayerHandInventory.get(equipmentSlot.getIndex());
            ItemStack newStack = this.getItemBySlot(equipmentSlot);
            if (ItemStack.matches((ItemStack)newStack, (ItemStack)oldStack)) continue;
            if (!oldStack.isEmpty()) {
                attributeMap = this.getAttributes();
                oldStack.forEachModifier(equipmentSlot, (attribute, attributeModifier) -> {
                    AttributeInstance attributeinstance = attributeMap.getInstance(attribute);
                    if (attributeinstance != null) {
                        attributeinstance.removeModifier(attributeModifier);
                    }
                    EnchantmentHelper.stopLocationBasedEffects((ItemStack)oldStack, (LivingEntity)this, (EquipmentSlot)equipmentSlot);
                });
            }
            if (!newStack.isEmpty()) {
                attributeMap = this.getAttributes();
                newStack.forEachModifier(equipmentSlot, (attribute, attributeModifier) -> {
                    Level patt0$temp;
                    AttributeInstance attributeinstance = attributeMap.getInstance(attribute);
                    if (attributeinstance != null) {
                        attributeinstance.removeModifier(attributeModifier.id());
                        attributeinstance.addTransientModifier(attributeModifier);
                    }
                    if ((patt0$temp = this.level()) instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)patt0$temp;
                        EnchantmentHelper.runLocationChangedEffects((ServerLevel)serverlevel, (ItemStack)newStack, (LivingEntity)this, (EquipmentSlot)equipmentSlot);
                    }
                });
            }
            this.setItemSlot(equipmentSlot, newStack.isEmpty() ? ItemStack.EMPTY : newStack);
            break;
        }
        this.attackStrengthTicker = (int)this.getCurrentItemAttackStrengthDelay();
    }

    protected void onEffectAdded(MobEffectInstance effect, @Nullable Entity entity) {
    }

    protected void onEffectUpdated(MobEffectInstance effect, boolean updateAttributes, @Nullable Entity entity) {
    }

    protected void onEffectsRemoved(Collection<MobEffectInstance> p_366811_) {
    }
}

