/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import reliquary.init.ModEntities;
import reliquary.item.IceMagusRodItem;
import reliquary.reference.Config;
import reliquary.util.RandHelper;

public class SpecialSnowball
extends ThrowableItemProjectile {
    private boolean fromGlacialStaff;

    public SpecialSnowball(EntityType<SpecialSnowball> entityType, Level level) {
        super(entityType, level);
    }

    public SpecialSnowball(Level level, LivingEntity entity, boolean b) {
        super(ModEntities.SPECIAL_SNOWBALL.get(), entity, level, new ItemStack((ItemLike)Items.SNOWBALL));
        this.setOwner((Entity)entity);
        this.fromGlacialStaff = b;
    }

    private int getSnowballDamage() {
        return this.fromGlacialStaff ? (Integer)Config.COMMON.items.glacialStaff.snowballDamage.get() : (Integer)Config.COMMON.items.iceMagusRod.snowballDamage.get();
    }

    private int getSnowballDamageFireImmuneBonus() {
        return this.fromGlacialStaff ? (Integer)Config.COMMON.items.glacialStaff.snowballDamageBonusFireImmune.get() : (Integer)Config.COMMON.items.iceMagusRod.snowballDamageBonusFireImmune.get();
    }

    private int getSnowballDamageBlazeBonus() {
        return this.fromGlacialStaff ? (Integer)Config.COMMON.items.glacialStaff.snowballDamageBonusBlaze.get() : (Integer)Config.COMMON.items.iceMagusRod.snowballDamageBonusBlaze.get();
    }

    protected void onHit(HitResult result) {
        for (int var3 = 0; var3 < 8; ++var3) {
            this.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SNOWBALL, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        if (!this.level().isClientSide) {
            if (result.getType() == HitResult.Type.ENTITY) {
                Entity entityHit = ((EntityHitResult)result).getEntity();
                int damage = this.getSnowballDamage();
                if (entityHit.fireImmune()) {
                    damage += this.getSnowballDamageFireImmuneBonus();
                }
                if (entityHit instanceof Blaze) {
                    damage += this.getSnowballDamageBlazeBonus();
                }
                entityHit.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)damage);
            } else if (result.getType() == HitResult.Type.BLOCK) {
                BlockPos posUp = ((BlockHitResult)result).getBlockPos().above();
                if (this.level().getBlockState(posUp).getBlock() instanceof BaseFireBlock) {
                    this.level().playSound(null, posUp, SoundEvents.GENERIC_BURN, SoundSource.NEUTRAL, 0.5f, RandHelper.getRandomMinusOneToOne(this.level().random) * 0.8f);
                    this.level().setBlockAndUpdate(posUp, Blocks.AIR.defaultBlockState());
                }
            }
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 4 == this.level().random.nextInt(5)) {
            this.level().addParticle((ParticleOptions)IceMagusRodItem.ICE_PARTICLE, this.getX(), this.getY(), this.getZ(), 5.0, 5.0, 1.0);
        }
    }

    protected double getDefaultGravity() {
        return 0.01f;
    }

    protected Item getDefaultItem() {
        return Items.SNOWBALL;
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ItemStack stack = this.getItem();
            SimpleParticleType particleData = stack.isEmpty() ? ParticleTypes.ITEM_SNOWBALL : new ItemParticleOption(ParticleTypes.ITEM, stack);
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)particleData, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = 4.0;
        return distance < (d0 *= 64.0) * d0;
    }
}

