/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.potion;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.entity.potion.ThrownPotionBase;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.reference.Colors;

public class FertilePotion
extends ThrownPotionBase {
    public FertilePotion(EntityType<FertilePotion> entityType, Level level) {
        super(entityType, level, new ItemStack((ItemLike)ModItems.FERTILE_POTION.get()));
    }

    public FertilePotion(Level level, Player player) {
        super(ModEntities.FERTILE_POTION.get(), level, player, new ItemStack((ItemLike)ModItems.FERTILE_POTION.get()));
    }

    public FertilePotion(Level level, Position position) {
        super(ModEntities.FERTILE_POTION.get(), level, position.x(), position.y(), position.z(), new ItemStack((ItemLike)ModItems.FERTILE_POTION.get()));
    }

    @Override
    boolean hasLivingEntityEffect() {
        return false;
    }

    @Override
    void doGroundSplashEffect() {
        BlockPos.betweenClosedStream((BlockPos)this.blockPosition().offset(-1, -2, -1), (BlockPos)this.blockPosition().offset(1, 1, 1)).forEach(pos -> BoneMealItem.growCrop((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)this.level(), (BlockPos)pos));
    }

    @Override
    void doLivingSplashEffect(LivingEntity e) {
    }

    @Override
    int getColor() {
        return Colors.get("C9C9C9");
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)ModItems.FERTILE_POTION.get());
    }
}

