/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.shot;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import reliquary.entity.shot.ShotBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class BlazeShot
extends ShotBase {
    public BlazeShot(EntityType<BlazeShot> entityType, Level level) {
        super(entityType, level);
    }

    public BlazeShot(Level level, Player player, InteractionHand hand) {
        super(ModEntities.BLAZE_SHOT.get(), level, player, hand);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0 && this.ticksInAir < 9) {
            Vec3 motion = this.getDeltaMovement();
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), this.lowGauss(motion.x()), this.lowGauss(motion.y()), this.lowGauss(motion.z()));
        }
    }

    @Override
    void doFiringEffects() {
        this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.5f, (float)0.5f, (float)0.5f), this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.FLAME);
    }

    @Override
    protected DamageSource getDamageSource(LivingEntity livingEntity) {
        return livingEntity.damageSources().source(DamageTypes.FIREBALL, this.getOwner(), (Entity)this);
    }

    @Override
    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.ENTITY) {
            Entity entityHit = ((EntityHitResult)result).getEntity();
            if (entityHit == this.getOwner() || !(entityHit instanceof LivingEntity)) {
                return;
            }
            this.onImpact((LivingEntity)entityHit);
        } else if (result.getType() == HitResult.Type.BLOCK) {
            if (!(this.getOwner() instanceof Player)) {
                return;
            }
            BlockHitResult blockResult = (BlockHitResult)result;
            this.groundImpact(blockResult.getDirection());
            BlockPos fireSpawnPos = blockResult.getBlockPos().relative(blockResult.getDirection());
            if (this.level().isEmptyBlock(fireSpawnPos)) {
                this.level().setBlockAndUpdate(fireSpawnPos, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)fireSpawnPos));
            }
        }
    }

    @Override
    protected void onImpact(LivingEntity livingEntity) {
        livingEntity.igniteForSeconds(40.0f);
        super.onImpact(livingEntity);
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.FLAME);
        }
    }

    @Override
    protected void groundImpact(Direction sideHit) {
        this.discard();
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return mop.fireImmune() ? 2 : 10 + this.d12();
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        Vec3 motion = this.getDeltaMovement();
        double motionX = motion.x();
        double motionY = motion.y();
        double motionZ = motion.z();
        block8: for (int particles = 0; particles < 40; ++particles) {
            switch (sideHit) {
                case DOWN: {
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), this.smallGauss(0.1) + motionX / 4.0, -this.posGauss(0.2), this.smallGauss(0.2) + motionZ / 4.0);
                    continue block8;
                }
                case UP: {
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), this.smallGauss(0.1) + motionX / 4.0, this.posGauss(0.2), this.smallGauss(0.2) + motionZ / 4.0);
                    continue block8;
                }
                case NORTH: {
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), this.smallGauss(0.1) + motionX / 4.0, this.smallGauss(0.1) + motionY / 4.0, -this.posGauss(0.2));
                    continue block8;
                }
                case SOUTH: {
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), this.smallGauss(0.1) + motionX / 4.0, this.smallGauss(0.1) + motionY / 4.0, this.posGauss(0.2));
                    continue block8;
                }
                case WEST: {
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), -this.posGauss(0.2), this.smallGauss(0.1) + motionY / 4.0, this.smallGauss(0.1) + motionZ / 4.0);
                    continue block8;
                }
                case EAST: {
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), this.posGauss(0.2), this.smallGauss(0.1) + motionY / 4.0, this.smallGauss(0.1) + motionZ / 4.0);
                    continue block8;
                }
            }
        }
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.BLAZE;
    }
}

