/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import reliquary.common.gui.AlkahestTomeMenu;
import reliquary.crafting.AlkahestryChargingRecipe;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModDataComponents;
import reliquary.init.ModItems;
import reliquary.init.ModSounds;
import reliquary.item.ChargeableItem;
import reliquary.reference.Config;
import reliquary.util.TooltipBuilder;

public class AlkahestryTomeItem
extends ChargeableItem {
    public AlkahestryTomeItem(Item.Properties properties) {
        super(properties.setNoCombineRepair().rarity(Rarity.EPIC).stacksTo(1).durability(10).component(DataComponents.REPAIR_COST, (Object)Integer.MAX_VALUE), (Supplier<Boolean>)Config.COMMON.disable.disableAlkahestry);
    }

    public int getMaxDamage(ItemStack stack) {
        return AlkahestryTomeItem.getChargeLimit() + 1;
    }

    public int getDamage(ItemStack stack) {
        return this.getMaxDamage(stack) - AlkahestryTomeItem.getCharge(stack);
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            return super.use(level, player, hand);
        }
        player.playSound(ModSounds.BOOK.get(), 1.0f, 1.0f);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> new AlkahestTomeMenu(w), stack.getHoverName()));
        }
        return InteractionResult.SUCCESS;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public void inventoryTick(ItemStack tome, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 10L != 0L || !this.isEnabled(tome) || AlkahestryTomeItem.getCharge(tome) == AlkahestryTomeItem.getChargeLimit()) {
            return;
        }
        for (AlkahestryChargingRecipe recipe : AlkahestryRecipeRegistry.getChargingRecipes()) {
            this.consumeAndCharge(tome, 0, player, AlkahestryTomeItem.getChargeLimit() - AlkahestryTomeItem.getCharge(tome), recipe.getChargeToAdd(), 16);
        }
    }

    @Override
    protected boolean isItemValidForContainerSlot(ItemStack containerStack, int slot, ItemStack stack) {
        return slot == 0 && AlkahestryRecipeRegistry.getChargingRecipes().stream().anyMatch(recipe -> recipe.getChargingIngredient().test(stack));
    }

    @Override
    protected void addMoreInformation(ItemStack tome, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        if (registries == null) {
            return;
        }
        tooltipBuilder.charge((Item)this, ".tooltip2", AlkahestryTomeItem.getCharge(tome), AlkahestryTomeItem.getChargeLimit());
        tooltipBuilder.description(this, ".tooltip3", new Object[0]);
        if (this.isEnabled(tome)) {
            tooltipBuilder.absorbActive(AlkahestryRecipeRegistry.getDrainRecipe().map(r -> r.getResultItem().getHoverName().getString()).orElse(""));
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public static int getChargeLimit() {
        return (Integer)Config.getOrDefault(Config.COMMON.items.alkahestryTome.chargeLimit, Config.COMMON_SPEC);
    }

    public static ItemStack setCharge(ItemStack tome, int charge) {
        tome.set(ModDataComponents.CHARGE, (Object)charge);
        return tome;
    }

    public static int getCharge(ItemStack tome) {
        return ((AlkahestryTomeItem)ModItems.ALKAHESTRY_TOME.get()).getStoredCharge(tome, 0);
    }

    public static void addCharge(ItemStack tome, int chargeToAdd) {
        ((AlkahestryTomeItem)ModItems.ALKAHESTRY_TOME.get()).addStoredCharge(tome, 0, chargeToAdd, null);
    }

    @Override
    public int getStoredCharge(ItemStack tome, int slot) {
        return (Integer)tome.getOrDefault(ModDataComponents.CHARGE, (Object)0);
    }

    @Override
    public void addStoredCharge(ItemStack tome, int slot, int chageToAdd, @Nullable ItemStack chargeStack) {
        AlkahestryTomeItem.setCharge(tome, this.getStoredCharge(tome, slot) + chageToAdd);
    }
}

