/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import reliquary.entity.EnderStaffProjectile;
import reliquary.init.ModBlocks;
import reliquary.init.ModDataComponents;
import reliquary.item.ChargeableItem;
import reliquary.item.util.IScrollableItem;
import reliquary.reference.Config;
import reliquary.util.TooltipBuilder;

public class EnderStaffItem
extends ChargeableItem
implements IScrollableItem {
    public EnderStaffItem(Item.Properties properties) {
        super(properties.stacksTo(1).setNoCombineRepair().rarity(Rarity.EPIC));
    }

    private int getEnderStaffPearlCost() {
        return (Integer)Config.COMMON.items.enderStaff.enderPearlCastCost.get();
    }

    private int getEnderStaffNodeWarpCost() {
        return (Integer)Config.COMMON.items.enderStaff.enderPearlNodeWarpCost.get();
    }

    private int getEnderPearlWorth() {
        return (Integer)Config.COMMON.items.enderStaff.enderPearlWorth.get();
    }

    private int getEnderPearlLimit() {
        return (Integer)Config.COMMON.items.enderStaff.enderPearlLimit.get();
    }

    private int getNodeWarpCastTime() {
        return (Integer)Config.COMMON.items.enderStaff.nodeWarpCastTime.get();
    }

    public Mode getMode(ItemStack stack) {
        return (Mode)((Object)stack.getOrDefault(ModDataComponents.ENDER_STAFF_MODE, (Object)Mode.CAST));
    }

    private void setMode(ItemStack stack, Mode mode) {
        stack.set(ModDataComponents.ENDER_STAFF_MODE, (Object)mode);
    }

    private void cycleMode(ItemStack stack, boolean next) {
        if (next) {
            this.setMode(stack, this.getMode(stack).next());
        } else {
            this.setMode(stack, this.getMode(stack).previous());
        }
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        if (player.level().isClientSide) {
            return InteractionResult.PASS;
        }
        this.cycleMode(stack, scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack staff, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 10L != 0L) {
            return;
        }
        if (!this.isEnabled(staff)) {
            return;
        }
        int pearlCharge = this.getPearlCount(staff);
        this.consumeAndCharge(staff, 0, player, this.getEnderPearlLimit() - pearlCharge, 1, 16);
    }

    @Override
    public void addStoredCharge(ItemStack staff, int slot, int chargeToAdd, @Nullable ItemStack chargeStack) {
        this.runOnHandler(staff, handler -> handler.setStackInSlot(0, new ItemStack((ItemLike)Items.ENDER_PEARL, this.getPearlCount(staff) + chargeToAdd)));
    }

    @Override
    public int getStoredCharge(ItemStack staff, int slot) {
        return this.getPearlCount(staff);
    }

    @Override
    protected int getSlotWorth(int slot) {
        return slot == 0 ? this.getEnderPearlWorth() : 0;
    }

    @Override
    protected boolean isItemValidForContainerSlot(ItemStack containerStack, int slot, ItemStack stack) {
        return stack.isEmpty() || stack.is(Tags.Items.ENDER_PEARLS);
    }

    @Override
    protected int getContainerSlotLimit(int slot) {
        return this.getEnderPearlLimit();
    }

    public int getPearlCount(ItemStack staff) {
        return this.getFromHandler(staff, handler -> handler.getCountInSlot(0));
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        for (int particles = 0; particles < 2; ++particles) {
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, player.getX(), player.getEyeY(), player.getZ(), player.level().random.nextGaussian(), player.level().random.nextGaussian(), player.level().random.nextGaussian());
        }
        if (remainingUseDuration == 1) {
            player.releaseUsingItem();
        }
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BLOCK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return this.getMode(stack) == Mode.NODE_WARP ? this.getNodeWarpCastTime() : 0;
    }

    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)livingEntity;
        if (timeLeft == 1) {
            this.doWraithNodeWarpCheck(stack, player.level(), player);
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isShiftKeyDown()) {
            if (this.getMode(stack) == Mode.CAST || this.getMode(stack) == Mode.LONG_CAST) {
                if (this.getPearlCount(stack) < this.getEnderStaffPearlCost() && !player.isCreative()) {
                    return InteractionResult.FAIL;
                }
                this.shootEnderStaffProjectile(level, player, hand, stack);
            } else {
                player.startUsingItem(hand);
            }
        }
        return super.use(level, player, hand);
    }

    private void shootEnderStaffProjectile(Level level, Player player, InteractionHand hand, ItemStack stack) {
        player.swing(hand);
        player.level().playSound(null, player.blockPosition(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!player.level().isClientSide) {
            EnderStaffProjectile enderStaffProjectile = new EnderStaffProjectile(player.level(), player, this.getMode(stack) != Mode.LONG_CAST);
            enderStaffProjectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            player.level().addFreshEntity((Entity)enderStaffProjectile);
            if (!player.isCreative()) {
                this.useCharge(stack, 0, this.getEnderStaffPearlCost());
            }
        }
    }

    private void doWraithNodeWarpCheck(ItemStack stack, Level level, Player player) {
        Level level2;
        if (!stack.has(ModDataComponents.WARP_DIMENSION) || !stack.has(ModDataComponents.WARP_POSITION) || this.getPearlCount(stack) < this.getEnderStaffNodeWarpCost() && !player.isCreative()) {
            return;
        }
        ResourceLocation wraithNodeDimension = (ResourceLocation)Preconditions.checkNotNull((Object)((ResourceLocation)stack.get(ModDataComponents.WARP_DIMENSION)));
        BlockPos wraithNodePos = (BlockPos)Preconditions.checkNotNull((Object)((BlockPos)stack.get(ModDataComponents.WARP_POSITION)));
        if (!player.level().dimension().location().equals((Object)wraithNodeDimension) && (level2 = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            ServerLevel destination = serverLevel.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)wraithNodeDimension));
            if (destination != null && EnderStaffItem.canTeleport((Level)destination, wraithNodePos)) {
                EnderStaffItem.teleportToDimension(player, destination, wraithNodePos);
                if (!player.isCreative() && !player.level().isClientSide) {
                    this.useCharge(stack, 0, this.getEnderStaffNodeWarpCost());
                }
            }
        } else if (EnderStaffItem.canTeleport(level, wraithNodePos)) {
            EnderStaffItem.teleportPlayer(level, wraithNodePos, player);
            if (!player.isCreative() && !player.level().isClientSide) {
                this.useCharge(stack, 0, this.getEnderStaffNodeWarpCost());
            }
        }
    }

    private static void teleportToDimension(Player player, ServerLevel destination, BlockPos wraithNodePos) {
        player.teleport(new TeleportTransition(destination, wraithNodePos.above().getBottomCenter(), Vec3.ZERO, player.getYRot(), player.getXRot(), TeleportTransition.DO_NOTHING));
    }

    private static boolean canTeleport(Level level, BlockPos pos) {
        if (level.getBlockState(pos).getBlock() != ModBlocks.WRAITH_NODE.get()) {
            return false;
        }
        BlockPos up = pos.above();
        return level.isEmptyBlock(up) && level.isEmptyBlock(up.above());
    }

    private static void teleportPlayer(Level level, BlockPos pos, Player player) {
        player.teleportTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.875, (double)pos.getZ() + 0.5);
        player.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
        for (int particles = 0; particles < 2; ++particles) {
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, player.getX(), player.getEyeY(), player.getZ(), level.random.nextGaussian(), level.random.nextGaussian(), level.random.nextGaussian());
        }
    }

    @Override
    protected void addMoreInformation(ItemStack staff, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.description(this, ".tooltip2", new Object[0]);
        tooltipBuilder.charge(this, ".tooltip.charge", this.getPearlCount(staff));
        if (staff.has(ModDataComponents.WARP_POSITION)) {
            ResourceLocation dimension = (ResourceLocation)staff.getOrDefault(ModDataComponents.WARP_DIMENSION, (Object)Level.OVERWORLD.location());
            BlockPos pos = (BlockPos)staff.getOrDefault(ModDataComponents.WARP_POSITION, (Object)BlockPos.ZERO);
            tooltipBuilder.data(this, ".tooltip.position", pos.getX(), pos.getY(), pos.getZ(), dimension);
        } else {
            tooltipBuilder.description(this, ".tooltip.position.nowhere", new Object[0]);
        }
        if (this.isEnabled(staff)) {
            tooltipBuilder.absorbActive(Items.ENDER_PEARL.getName(new ItemStack((ItemLike)Items.ENDER_PEARL)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public InteractionResult useOn(UseOnContext itemUseContext) {
        BlockPos pos;
        ItemStack stack = itemUseContext.getItemInHand();
        Level level = itemUseContext.getLevel();
        if (level.getBlockState(pos = itemUseContext.getClickedPos()).getBlock() == ModBlocks.WRAITH_NODE.get()) {
            this.setWraithNode(stack, pos, level.dimension().location());
            Player player = itemUseContext.getPlayer();
            if (player != null) {
                player.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            }
            for (int particles = 0; particles < 12; ++particles) {
                level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + level.random.nextDouble(), (double)pos.getY() + level.random.nextDouble(), (double)pos.getZ() + level.random.nextDouble(), level.random.nextGaussian(), level.random.nextGaussian(), level.random.nextGaussian());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void setWraithNode(ItemStack eye, BlockPos pos, ResourceLocation dimension) {
        eye.set(ModDataComponents.WARP_DIMENSION, (Object)dimension);
        eye.set(ModDataComponents.WARP_POSITION, (Object)pos);
    }

    public static enum Mode implements StringRepresentable
    {
        CAST("cast"),
        LONG_CAST("long_cast"),
        NODE_WARP("node_warp");

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Mode> STREAM_CODEC;
        private final String name;
        private static final Mode[] VALUES;

        private Mode(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public Mode previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Mode.class);
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode value : Mode.values()) {
                builder.put((Object)value.getSerializedName(), (Object)value);
            }
            VALUES = Mode.values();
        }
    }
}

