/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItem;
import reliquary.block.tile.PedestalBlockEntity;
import reliquary.init.ModDataComponents;
import reliquary.init.ModFluids;
import reliquary.init.ModItems;
import reliquary.item.ItemBase;
import reliquary.item.util.ICuriosItem;
import reliquary.pedestal.PedestalRegistry;
import reliquary.reference.Config;
import reliquary.util.RandHelper;
import reliquary.util.TooltipBuilder;
import reliquary.util.XpHelper;

public class FortuneCoinItem
extends ItemBase
implements IPedestalActionItem,
ICuriosItem {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    private static final Set<IFortuneCoinPickupChecker> pickupCheckers = new HashSet<IFortuneCoinPickupChecker>();

    public static void addFortuneCoinPickupChecker(IFortuneCoinPickupChecker checker) {
        pickupCheckers.add(checker);
    }

    public FortuneCoinItem(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.EPIC));
    }

    @Override
    public void onEquipped(String identifier, LivingEntity player) {
        if (player.level().isClientSide) {
            player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 2.2f));
        }
    }

    @Override
    public ICuriosItem.Type getCuriosType() {
        return ICuriosItem.Type.NECKLACE;
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        this.inventoryTick(stack, player.level(), (Entity)player, 0, false);
    }

    @Override
    protected void addMoreInformation(ItemStack stack, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.description(this, ".tooltip2", new Object[0]);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public boolean isFoil(ItemStack stack) {
        return FortuneCoinItem.isEnabled(stack);
    }

    public static boolean isEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.ENABLED, (Object)false);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 2L != 0L) {
            return;
        }
        if (!FortuneCoinItem.isEnabled(stack)) {
            return;
        }
        this.scanForEntitiesInRange(level, player, this.getStandardPullDistance());
    }

    private void scanForEntitiesInRange(Level level, Player player, double d) {
        List<BlockPos> disablePositions = this.getDisablePositions(level, player.blockPosition());
        List items = level.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(d));
        for (ItemEntity item : items) {
            if (!this.canPickupItem(item, disablePositions, false) || !this.checkForRoom(item.getItem(), player)) continue;
            item.setPickUpDelay(0);
            if (!((double)player.distanceTo((Entity)item) >= 1.5)) continue;
            this.teleportEntityToPlayer((Entity)item, player);
            break;
        }
        List xpOrbs = level.getEntitiesOfClass(ExperienceOrb.class, player.getBoundingBox().inflate(d));
        for (ExperienceOrb xpOrb : xpOrbs) {
            if (player.takeXpDelay > 0) {
                player.takeXpDelay = 0;
            }
            if (!((double)player.distanceTo((Entity)xpOrb) >= 1.5)) continue;
            this.teleportEntityToPlayer((Entity)xpOrb, player);
            break;
        }
    }

    private boolean canPickupItem(ItemEntity item, List<BlockPos> disablePositions, boolean isInPedestal) {
        CompoundTag data = item.getPersistentData();
        if (!(!data.getBoolean(PREVENT_REMOTE_MOVEMENT) || isInPedestal && data.getBoolean(ALLOW_MACHINE_MOVEMENT))) {
            return false;
        }
        if (this.isInDisabledRange(item, disablePositions)) {
            return false;
        }
        for (IFortuneCoinPickupChecker pickupChecker : pickupCheckers) {
            if (pickupChecker.canPickup(item)) continue;
            return false;
        }
        return true;
    }

    private boolean isInDisabledRange(ItemEntity item, List<BlockPos> disablePositions) {
        for (BlockPos disablePos : disablePositions) {
            if (Math.abs(item.blockPosition().getX() - disablePos.getX()) >= 5 || Math.abs(item.blockPosition().getY() - disablePos.getY()) >= 5 || Math.abs(item.blockPosition().getZ() - disablePos.getZ()) >= 5) continue;
            return true;
        }
        return false;
    }

    private List<BlockPos> getDisablePositions(Level level, BlockPos coinPos) {
        ArrayList<BlockPos> disablePositions = new ArrayList<BlockPos>();
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(level.dimension().registry(), coinPos, 10);
        for (BlockPos pos : pedestalPositions) {
            ItemStack stack;
            PedestalBlockEntity pedestal;
            BlockEntity te = level.getBlockEntity(pos);
            if (!(te instanceof PedestalBlockEntity) || !(pedestal = (PedestalBlockEntity)te).switchedOn() || (stack = pedestal.getItem()).isEmpty() || stack.getItem() != this || FortuneCoinItem.isEnabled(stack)) continue;
            disablePositions.add(pos);
        }
        return disablePositions;
    }

    private void teleportEntityToPlayer(Entity item, Player player) {
        player.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.9f, (float)0.9f, (float)0.0f), item.getX() + 0.5 + player.level().random.nextGaussian() / 8.0, item.getY() + 0.2, item.getZ() + 0.5 + player.level().random.nextGaussian() / 8.0, 0.0, 0.0, 0.0);
        player.getLookAngle();
        double x = player.getX() + player.getLookAngle().x * 0.2;
        double y = player.getY();
        double z = player.getZ() + player.getLookAngle().z * 0.2;
        item.setPos(x, y, z);
    }

    private boolean checkForRoom(ItemStack stackToPickup, Player player) {
        int remaining = stackToPickup.getCount();
        for (ItemStack inventoryStack : player.getInventory().items) {
            if (inventoryStack.isEmpty()) {
                return true;
            }
            if (inventoryStack.getItem() == stackToPickup.getItem() && inventoryStack.getDamageValue() == stackToPickup.getDamageValue()) {
                if (inventoryStack.getCount() + remaining <= inventoryStack.getMaxStackSize()) {
                    return true;
                }
                remaining -= inventoryStack.getMaxStackSize() - inventoryStack.getCount();
                continue;
            }
            if (inventoryStack.getItem() != ModItems.VOID_TEAR.get() || !ModItems.VOID_TEAR.get().isEnabled(inventoryStack) || !ModItems.VOID_TEAR.get().canAbsorbStack(stackToPickup, inventoryStack)) continue;
            return true;
        }
        return false;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        this.scanForEntitiesInRange(player.level(), player, this.getLongRangePullDistance());
    }

    private double getLongRangePullDistance() {
        return ((Integer)Config.COMMON.items.fortuneCoin.longRangePullDistance.get()).intValue();
    }

    private double getStandardPullDistance() {
        return ((Integer)Config.COMMON.items.fortuneCoin.standardPullDistance.get()).intValue();
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 64;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BLOCK;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.toggle(stack);
            player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.8f));
            return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
        }
        player.startUsingItem(hand);
        return InteractionResult.SUCCESS;
    }

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        if (level.isClientSide) {
            return;
        }
        if (FortuneCoinItem.isEnabled(stack)) {
            BlockPos pos = pedestal.getBlockPosition();
            this.pickupItems(pedestal, level, pos);
            this.pickupXp(pedestal, level, pos);
        }
    }

    private void pickupItems(IPedestal pedestal, Level level, BlockPos pos) {
        List<BlockPos> disablePositions = this.getDisablePositions(level, pos);
        List entities = level.getEntitiesOfClass(ItemEntity.class, new AABB(pos).inflate(this.getStandardPullDistance()));
        for (ItemEntity entityItem : entities) {
            if (!this.canPickupItem(entityItem, disablePositions, true)) continue;
            int numberAdded = pedestal.addToConnectedInventory(level, entityItem.getItem().copy());
            if (numberAdded > 0) {
                entityItem.getItem().setCount(entityItem.getItem().getCount() - numberAdded);
                if (entityItem.getItem().getCount() > 0) continue;
                entityItem.discard();
                continue;
            }
            pedestal.setActionCoolDown(20);
        }
    }

    private void pickupXp(IPedestal pedestal, Level level, BlockPos pos) {
        List xpOrbs = level.getEntitiesOfClass(ExperienceOrb.class, new AABB(pos).inflate(this.getStandardPullDistance()));
        for (ExperienceOrb xpOrb : xpOrbs) {
            int amountToTransfer = XpHelper.experienceToLiquid(xpOrb.value);
            int amountAdded = pedestal.fillConnectedTank(new FluidStack((Fluid)ModFluids.XP_STILL.get(), amountToTransfer));
            if (amountAdded > 0) {
                xpOrb.discard();
                if (amountToTransfer <= amountAdded) continue;
                level.addFreshEntity((Entity)new ExperienceOrb(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                continue;
            }
            pedestal.setActionCoolDown(20);
        }
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }

    public void toggle(ItemStack stack) {
        stack.set(ModDataComponents.ENABLED, (Object)(!FortuneCoinItem.isEnabled(stack) ? 1 : 0));
    }

    public static interface IFortuneCoinPickupChecker {
        public boolean canPickup(ItemEntity var1);
    }
}

