/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.util.TooltipBuilder;

public class ItemBase
extends Item
implements ICreativeTabItemGenerator {
    private final Supplier<Boolean> isDisabled;

    public ItemBase(Supplier<Boolean> isDisabled, Item.Properties properties) {
        this(properties, isDisabled);
    }

    public ItemBase(Item.Properties properties) {
        this(properties, () -> false);
    }

    public ItemBase(Item.Properties properties, Supplier<Boolean> isDisabled) {
        super(properties);
        this.isDisabled = isDisabled;
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(this.isDisabled.get())) {
            return;
        }
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        TooltipBuilder tooltipBuilder = TooltipBuilder.of(tooltip, context).itemTooltip(this);
        if (this.hasMoreInformation(stack)) {
            tooltipBuilder.showMoreInfo();
            if (Screen.hasShiftDown()) {
                this.addMoreInformation(stack, context.registries(), tooltipBuilder);
            }
        }
    }

    protected boolean hasMoreInformation(ItemStack stack) {
        return false;
    }

    protected void addMoreInformation(ItemStack stack, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
    }

    public MutableComponent getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId());
    }
}

