/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import reliquary.handler.CommonEventHandler;
import reliquary.handler.HandlerPriority;
import reliquary.handler.IPlayerHurtHandler;
import reliquary.init.ModItems;
import reliquary.item.ItemBase;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;

public class KrakenShellItem
extends ItemBase {
    public KrakenShellItem(Item.Properties properties) {
        super(properties.stacksTo(1));
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(this){

            @Override
            public boolean canApply(Player player, LivingIncomingDamageEvent event) {
                return event.getSource() == player.damageSources().drown() && player.getFoodData().getFoodLevel() > 0 && InventoryHelper.playerHasItem(player, ModItems.KRAKEN_SHELL.get());
            }

            @Override
            public boolean apply(Player player, LivingIncomingDamageEvent event) {
                float hungerDamage = event.getAmount() * ((float)((Integer)Config.COMMON.items.krakenShell.hungerCostPercent.get()).intValue() / 100.0f);
                player.causeFoodExhaustion(hungerDamage);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (level.getGameTime() % 3L != 0L) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).isInWater()) {
            player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 5, 0, true, false));
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 5, 0, true, false));
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 220, 0, true, false));
        }
    }
}

