/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import reliquary.Reliquary;
import reliquary.data.ReliquaryEnchantmentProvider;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.util.TooltipBuilder;

public class MagicbaneItem
extends SwordItem
implements ICreativeTabItemGenerator {
    private static final ResourceLocation MAGICBANE_ENCHANTMENTS_BONUS_ID = Reliquary.getRL("magicbane_enchantments_bonus");

    public MagicbaneItem(Item.Properties properties) {
        super(ToolMaterial.GOLD, 4.0f, -2.4f, properties.durability(16).setNoCombineRepair().rarity(Rarity.EPIC));
        NeoForge.EVENT_BUS.addListener(this::adjustDamageBasedOnEnchantments);
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack magicBane, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        TooltipBuilder.of(tooltip, context).itemTooltip((Item)this);
    }

    public float getDestroySpeed(ItemStack stack, BlockState blockState) {
        return blockState.getBlock() == Blocks.COBWEB ? 15.0f : 1.5f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int random = target.level().random.nextInt(16);
        switch (random) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 2));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 2));
                break;
            }
            case 12: 
            case 13: {
                target.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 2));
                target.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 2));
                break;
            }
            case 14: {
                target.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 2));
                target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 2));
                break;
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(ReliquaryEnchantmentProvider.SEVERING)) {
            return super.getEnchantmentLevel(stack, enchantment) + 2;
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    private void adjustDamageBasedOnEnchantments(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.getItem() instanceof MagicbaneItem)) {
            return;
        }
        ItemEnchantments enchantments = stack.getTagEnchantments();
        float attackDamage = 0.0f;
        for (Object2IntMap.Entry holderEntry : enchantments.entrySet()) {
            attackDamage += (float)holderEntry.getIntValue();
        }
        event.addModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(MAGICBANE_ENCHANTMENTS_BONUS_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }
}

