/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import reliquary.data.ReliquaryEnchantmentProvider;
import reliquary.init.ModItems;
import reliquary.item.MobCharmDefinition;
import reliquary.item.MobCharmItem;
import reliquary.reference.Config;
import reliquary.util.RegistryHelper;

public class MobCharmRegistry {
    private static final Map<ResourceLocation, MobCharmDefinition> REGISTERED_CHARM_DEFINITIONS = new HashMap<ResourceLocation, MobCharmDefinition>();
    private static final Map<ResourceLocation, MobCharmDefinition> ENTITY_NAME_CHARM_DEFINITIONS = new HashMap<ResourceLocation, MobCharmDefinition>();
    private static final Set<ResourceLocation> DYNAMICALLY_REGISTERED = new HashSet<ResourceLocation>();

    private MobCharmRegistry() {
    }

    public static void registerMobCharmDefinition(MobCharmDefinition charmDefinition) {
        REGISTERED_CHARM_DEFINITIONS.put(charmDefinition.getRegistryName(), charmDefinition);
        for (ResourceLocation registryName : charmDefinition.getEntities()) {
            ENTITY_NAME_CHARM_DEFINITIONS.put(registryName, charmDefinition);
        }
    }

    static Optional<MobCharmDefinition> getCharmDefinitionFor(Entity entity) {
        return Optional.ofNullable(ENTITY_NAME_CHARM_DEFINITIONS.get(RegistryHelper.getRegistryName(entity)));
    }

    public static Optional<MobCharmDefinition> getCharmDefinitionFor(ItemStack stack) {
        if (stack.getItem() != ModItems.MOB_CHARM.get()) {
            return Optional.empty();
        }
        return Optional.ofNullable(ENTITY_NAME_CHARM_DEFINITIONS.get(MobCharmItem.getEntityEggRegistryName(stack)));
    }

    public static Set<ResourceLocation> getRegisteredNames() {
        return REGISTERED_CHARM_DEFINITIONS.keySet();
    }

    public static void registerDynamicCharmDefinitions() {
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            ResourceLocation registryName = EntityType.getKey((EntityType)entityType);
            if (ENTITY_NAME_CHARM_DEFINITIONS.containsKey(registryName) || entityType.getCategory() != MobCategory.MONSTER || Config.COMMON.items.mobCharm.isBlockedEntity(registryName)) continue;
            MobCharmRegistry.registerMobCharmDefinition(new MobCharmDefinition(entityType));
            DYNAMICALLY_REGISTERED.add(registryName);
        }
    }

    public static void handleAddingFragmentDrops(LivingDropsEvent evt) {
        Entity entity;
        if (Boolean.TRUE.equals(Config.COMMON.disable.disableCharms.get()) || !((entity = evt.getSource().getDirectEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LivingEntity entity2 = evt.getEntity();
        ResourceLocation regName = RegistryHelper.getRegistryName((Entity)entity2);
        if (!DYNAMICALLY_REGISTERED.contains(regName)) {
            return;
        }
        Registry registrylookup = entity2.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        int lootingLevel = EnchantmentHelper.getEnchantmentLevel((Holder)registrylookup.getOrThrow(Enchantments.LOOTING), (LivingEntity)player);
        int severingLevel = EnchantmentHelper.getEnchantmentLevel((Holder)registrylookup.getOrThrow(ReliquaryEnchantmentProvider.SEVERING), (LivingEntity)player);
        double dynamicDropChance = (Double)Config.COMMON.items.mobCharmFragment.dropChance.get() + (double)lootingLevel * (Double)Config.COMMON.items.mobCharmFragment.lootingMultiplier.get() + (double)(severingLevel * 3) * (Double)Config.COMMON.items.mobCharmFragment.lootingMultiplier.get();
        if ((double)entity2.level().random.nextFloat() < dynamicDropChance) {
            ItemEntity fragmentItemEntity = new ItemEntity(entity2.level(), entity2.getX(), entity2.getY(), entity2.getZ(), ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(regName));
            fragmentItemEntity.setDefaultPickUpDelay();
            evt.getDrops().add(fragmentItemEntity);
        }
    }

    static {
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ZOMBIE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SKELETON);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.WITHER_SKELETON);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.CREEPER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.WITCH);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ZOMBIFIED_PIGLIN);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.CAVE_SPIDER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SPIDER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ENDERMAN);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.GHAST);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SLIME);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.MAGMA_CUBE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.BLAZE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.GUARDIAN);
    }
}

