/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.level.Level;
import reliquary.init.ModItems;
import reliquary.item.PotionItemBase;
import reliquary.util.potions.PotionHelper;

public class PotionItem
extends PotionItemBase {
    public PotionItem(Item.Properties properties) {
        super(properties.component(DataComponents.CONSUMABLE, (Object)Consumables.DEFAULT_DRINK).usingConvertsTo((Item)ModItems.EMPTY_POTION_VIAL.get()));
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 16;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack result = super.finishUsingItem(stack, level, entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide) {
                PotionHelper.applyEffectsToEntity((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY), (Entity)player, null, (LivingEntity)player);
            }
        }
        return stack;
    }
}

