/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import reliquary.init.ModDataComponents;
import reliquary.item.ChargeableItem;
import reliquary.item.util.IScrollableItem;
import reliquary.reference.Config;
import reliquary.util.RandHelper;
import reliquary.util.TooltipBuilder;

public class PyromancerStaffItem
extends ChargeableItem
implements IScrollableItem {
    private static final int EFFECT_COOLDOWN = 2;
    private static final int INVENTORY_SEARCH_COOLDOWN = 10;
    public static final int BLAZE_POWDER_SLOT = 0;
    public static final int FIRE_CHARGE_SLOT = 1;

    public PyromancerStaffItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).withStyle(ChatFormatting.RED);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean f) {
        Player player;
        if (level.isClientSide() || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 2L != 0L) {
            return;
        }
        this.doFireballAbsorbEffect(stack, player);
        if (!this.isEnabled(stack)) {
            this.doExtinguishEffect(player);
        } else {
            this.scanForFireChargeAndBlazePowder(stack, player);
        }
    }

    @Override
    protected void addMoreInformation(ItemStack staff, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        AtomicInteger charges = new AtomicInteger(0);
        AtomicInteger blaze = new AtomicInteger(0);
        this.runOnHandler(staff, handler -> {
            charges.set(handler.getCountInSlot(1));
            blaze.set(handler.getCountInSlot(0));
        });
        tooltipBuilder.charge(this, ".tooltip.charges", charges.get());
        tooltipBuilder.charge(this, ".tooltip.blaze", blaze.get());
        tooltipBuilder.description(this, ".tooltip.controls", new Object[0]);
        if (this.isEnabled(staff)) {
            tooltipBuilder.absorbActive(Items.BLAZE_POWDER.getName(new ItemStack((ItemLike)Items.BLAZE_POWDER)).getString() + " & " + Items.FIRE_CHARGE.getName(new ItemStack((ItemLike)Items.FIRE_CHARGE)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 11;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BLOCK;
    }

    public Mode getMode(ItemStack stack) {
        return (Mode)((Object)stack.getOrDefault(ModDataComponents.PYROMANCER_STAFF_MODE, (Object)Mode.BLAZE));
    }

    private void setMode(ItemStack stack, Mode mode) {
        stack.set(ModDataComponents.PYROMANCER_STAFF_MODE, (Object)mode);
    }

    private void cycleMode(ItemStack stack, boolean next) {
        this.setMode(stack, next ? this.getMode(stack).next() : this.getMode(stack).previous());
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        if (player.level().isClientSide) {
            return InteractionResult.PASS;
        }
        this.cycleMode(stack, scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            super.use(level, player, hand);
        } else if (this.getMode(stack) == Mode.BLAZE) {
            player.swing(hand);
            this.shootBlazeFireball(player, stack);
        } else if (this.getMode(stack) == Mode.FIRE_CHARGE) {
            player.swing(hand);
            Vec3 lookVec = player.getLookAngle();
            this.shootGhastFireball(player, stack, lookVec);
        } else {
            player.startUsingItem(hand);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
    }

    private void shootGhastFireball(Player player, ItemStack stack, Vec3 lookVec) {
        if (this.getFireChargeCount(stack) >= this.getFireChargeCost()) {
            player.level().levelEvent(player, 1016, player.blockPosition(), 0);
            if (!player.level().isClientSide() && this.useCharge(stack, 1, this.getFireChargeCost())) {
                LargeFireball fireball = new LargeFireball(player.level(), (LivingEntity)player, lookVec, 1);
                fireball.setPos(fireball.getX() + lookVec.x, player.getY() + (double)player.getEyeHeight(), fireball.getZ() + lookVec.z);
                player.level().addFreshEntity((Entity)fireball);
            }
        }
    }

    private void shootBlazeFireball(Player player, ItemStack stack) {
        Vec3 lookVec = player.getLookAngle();
        if (this.getBlazePowderCount(stack) >= this.getBlazePowderCost()) {
            player.level().levelEvent(player, 1018, player.blockPosition(), 0);
            if (!player.level().isClientSide() && this.useCharge(stack, 0, this.getBlazePowderCost())) {
                SmallFireball fireball = new SmallFireball(player.level(), (LivingEntity)player, lookVec);
                fireball.setPos(fireball.getX() + lookVec.x, player.getY() + (double)player.getEyeHeight(), fireball.getZ() + lookVec.z);
                player.level().addFreshEntity((Entity)fireball);
            }
        }
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        Player player;
        HitResult rayTraceResult;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        if (this.getMode(stack) == Mode.ERUPTION && this.getBlazePowderCount(stack) > 0 && (rayTraceResult = (player = (Player)livingEntity).pick(12.0, 1.0f, true)).getType() == HitResult.Type.BLOCK) {
            --remainingUseDuration;
            remainingUseDuration = this.getUseDuration(stack, livingEntity) - remainingUseDuration;
            BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
            this.doEruptionAuxEffects(player, blockRayTraceResult.getBlockPos().getX(), blockRayTraceResult.getBlockPos().getY(), blockRayTraceResult.getBlockPos().getZ());
            if (remainingUseDuration % 10 == 0 && this.removeItemFromInternalStorage(stack, 0, this.getBlazePowderCost(), player.level().isClientSide, player)) {
                this.doEruptionEffect(player, blockRayTraceResult.getBlockPos().getX(), blockRayTraceResult.getBlockPos().getY(), blockRayTraceResult.getBlockPos().getZ());
            }
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(context.getHand());
        if (this.getMode(stack) == Mode.FLINT_AND_STEEL) {
            return Items.FLINT_AND_STEEL.useOn(new UseOnContext(context.getLevel(), player, context.getHand(), new ItemStack((ItemLike)Items.FLINT_AND_STEEL), context.getHitResult()));
        }
        return InteractionResult.PASS;
    }

    private void doEruptionAuxEffects(Player player, int soundX, int soundY, int soundZ) {
        if (player.level().getRandom().nextFloat() < 0.1f) {
            player.level().playLocalSound((double)soundX + 0.5, (double)soundY + 0.5, (double)soundZ + 0.5, SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL, 0.2f, 0.03f + 0.07f * player.level().random.nextFloat(), false);
        }
        this.spawnLavaParticles(player, soundX, soundY, soundZ);
        this.spawnFlameParticles(player, soundX, soundY, soundZ);
    }

    private void spawnFlameParticles(Player player, int soundX, int soundY, int soundZ) {
        double randZ;
        double randX;
        int particleCount;
        for (particleCount = 0; particleCount < 6; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.level().random.nextFloat() - 0.5f) * 5.0;
            randZ = (double)soundZ + 0.5 + (double)(player.level().random.nextFloat() - 0.5f) * 5.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.level().addParticle((ParticleOptions)ParticleTypes.FLAME, randX, (double)soundY + 1.0, randZ, player.level().random.nextGaussian() * 0.2, player.level().random.nextGaussian() * 0.2, player.level().random.nextGaussian() * 0.2);
        }
        for (particleCount = 0; particleCount < 8; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.level().random.nextFloat() - 0.5f) * 5.0 / 2.0;
            randZ = (double)soundZ + 0.5 + (double)(player.level().random.nextFloat() - 0.5f) * 5.0 / 2.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.level().addParticle((ParticleOptions)ParticleTypes.FLAME, randX, (double)soundY + 1.0, randZ, player.level().random.nextGaussian() * 0.2, player.level().random.nextGaussian() * 0.2, player.level().random.nextGaussian() * 0.2);
        }
    }

    private void spawnLavaParticles(Player player, int soundX, int soundY, int soundZ) {
        double randZ;
        double randX;
        int particleCount;
        for (particleCount = 0; particleCount < 2; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.level().random.nextFloat() - 0.5f) * 5.0;
            randZ = (double)soundZ + 0.5 + (double)(player.level().random.nextFloat() - 0.5f) * 5.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.level().addParticle((ParticleOptions)ParticleTypes.LAVA, randX, (double)soundY + 1.0, randZ, 0.0, 0.0, 0.0);
        }
        for (particleCount = 0; particleCount < 4; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.level().random.nextFloat() - 0.5f) * 5.0 / 2.0;
            randZ = (double)soundZ + 0.5 + (double)(player.level().random.nextFloat() - 0.5f) * 5.0 / 2.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.level().addParticle((ParticleOptions)ParticleTypes.LAVA, randX, (double)soundY + 1.0, randZ, 0.0, 0.0, 0.0);
        }
    }

    private void doEruptionEffect(Player player, int x, int y, int z) {
        double lowerX = (double)x - 5.0 + 0.5;
        double lowerZ = (double)z - 5.0 + 0.5;
        double upperX = (double)x + 5.0 + 0.5;
        double upperY = (double)y + 5.0;
        double upperZ = (double)z + 5.0 + 0.5;
        List entities = player.level().getEntitiesOfClass(Mob.class, new AABB(lowerX, (double)y, lowerZ, upperX, upperY, upperZ));
        entities.stream().filter(e -> !e.is((Entity)player)).forEach(e -> {
            e.igniteForSeconds(40.0f);
            if (!e.fireImmune()) {
                e.hurt(player.damageSources().playerAttack(player), 4.0f);
            }
        });
    }

    private void scanForFireChargeAndBlazePowder(ItemStack staff, Player player) {
        if (player.level().getGameTime() % 10L != 0L) {
            return;
        }
        int currentFireChargeCount = this.getFireChargeCount(staff);
        this.consumeAndCharge(staff, 1, player, this.getFireChargeLimit() - currentFireChargeCount, 1, 16);
        int currentBlazePowderCount = this.getBlazePowderCount(staff);
        this.consumeAndCharge(staff, 0, player, this.getBlazePowderLimit() - currentBlazePowderCount, 1, 16);
    }

    @Override
    public void addStoredCharge(ItemStack containerStack, int slot, int chargeToAdd, @Nullable ItemStack chargeStack) {
        if (chargeStack == null || chargeStack.isEmpty()) {
            return;
        }
        this.runOnHandler(containerStack, handler -> handler.insertItemOrAddIntoNewSlotIfNoStackMatches(chargeStack));
    }

    @Override
    protected void extractStoredCharge(ItemStack containerStack, int slot, int chargeToExtract) {
        this.runOnHandler(containerStack, h -> h.extractItem(slot, chargeToExtract, false));
    }

    @Override
    public int getStoredCharge(ItemStack containerStack, int slot) {
        if (slot == 0) {
            return this.getBlazePowderCount(containerStack);
        }
        if (slot == 1) {
            return this.getFireChargeCount(containerStack);
        }
        return 0;
    }

    private int getFireChargeWorth() {
        return (Integer)Config.COMMON.items.pyromancerStaff.fireChargeWorth.get();
    }

    private int getFireChargeCost() {
        return (Integer)Config.COMMON.items.pyromancerStaff.fireChargeCost.get();
    }

    private int getFireChargeLimit() {
        return (Integer)Config.COMMON.items.pyromancerStaff.fireChargeLimit.get();
    }

    private int getBlazePowderWorth() {
        return (Integer)Config.COMMON.items.pyromancerStaff.blazePowderWorth.get();
    }

    private int getBlazePowderCost() {
        return (Integer)Config.COMMON.items.pyromancerStaff.blazePowderCost.get();
    }

    private int getBlazePowderLimit() {
        return (Integer)Config.COMMON.items.pyromancerStaff.blazePowderLimit.get();
    }

    private int getBlazeAbsorbWorth() {
        return (Integer)Config.COMMON.items.pyromancerStaff.blazeAbsorbWorth.get();
    }

    private int getGhastAbsorbWorth() {
        return (Integer)Config.COMMON.items.pyromancerStaff.ghastAbsorbWorth.get();
    }

    private void doExtinguishEffect(Player player) {
        if (player.isOnFire()) {
            player.clearFire();
        }
        BlockPos.betweenClosed((BlockPos)player.blockPosition().offset(-3, -3, -3), (BlockPos)player.blockPosition().offset(3, 3, 3)).forEach(pos -> {
            Block block = player.level().getBlockState(pos).getBlock();
            if (block instanceof BaseFireBlock) {
                player.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                player.level().playSound(null, pos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.level().random) * 0.8f);
            }
        });
    }

    private void doFireballAbsorbEffect(ItemStack stack, Player player) {
        if (player.level().isClientSide) {
            return;
        }
        this.absorbGhastFireballs(stack, player);
        this.absorbBlazeFireballs(stack, player);
    }

    private void absorbBlazeFireballs(ItemStack stack, Player player) {
        List blazeFireballs = player.level().getEntitiesOfClass(SmallFireball.class, player.getBoundingBox().inflate(3.0));
        for (SmallFireball fireball : blazeFireballs) {
            if (fireball.getOwner() == player) continue;
            if (this.addPartialCharge(stack, 0, this.getBlazeAbsorbWorth())) {
                for (int particles = 0; particles < 4; ++particles) {
                    player.level().addParticle((ParticleOptions)DustParticleOptions.REDSTONE, fireball.getX(), fireball.getY(), fireball.getZ(), 0.0, 1.0, 1.0);
                }
                player.level().playLocalSound(fireball.getX(), fireball.getY(), fireball.getZ(), SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.level().random) * 0.8f, false);
            }
            fireball.discard();
        }
    }

    private void absorbGhastFireballs(ItemStack stack, Player player) {
        List ghastFireballs = player.level().getEntitiesOfClass(LargeFireball.class, player.getBoundingBox().inflate(4.0));
        for (LargeFireball fireball : ghastFireballs) {
            if (fireball.getOwner() == player) continue;
            if (this.addPartialCharge(stack, 1, this.getGhastAbsorbWorth())) {
                player.level().playLocalSound(fireball.getX(), fireball.getY(), fireball.getZ(), SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.level().random) * 0.8f, false);
            }
            fireball.discard();
        }
    }

    @Override
    protected int getContainerInitialSize() {
        return 2;
    }

    @Override
    protected int getSlotWorth(int slot) {
        return slot == 0 ? this.getBlazePowderWorth() : this.getFireChargeWorth();
    }

    @Override
    protected int getContainerSlotLimit(int slot) {
        if (slot == 0) {
            return (Integer)Config.COMMON.items.pyromancerStaff.blazePowderLimit.get();
        }
        return (Integer)Config.COMMON.items.pyromancerStaff.fireChargeLimit.get();
    }

    @Override
    protected boolean isItemValidForContainerSlot(ItemStack containerStack, int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        if (slot == 0) {
            return stack.is(Items.BLAZE_POWDER);
        }
        return stack.is(Items.FIRE_CHARGE);
    }

    public int getBlazePowderCount(ItemStack staff) {
        return this.getFromHandler(staff, handler -> handler.getCountInSlot(0));
    }

    public int getFireChargeCount(ItemStack staff) {
        return this.getFromHandler(staff, handler -> handler.getCountInSlot(1));
    }

    public static enum Mode implements StringRepresentable
    {
        BLAZE,
        FIRE_CHARGE,
        ERUPTION,
        FLINT_AND_STEEL;

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Mode> STREAM_CODEC;
        private static final Mode[] VALUES;

        public String getSerializedName() {
            return this.name();
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public Mode previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Mode.class);
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode value : Mode.values()) {
                builder.put((Object)value.getSerializedName(), (Object)value);
            }
            VALUES = Mode.values();
        }
    }
}

