/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import reliquary.init.ModDataComponents;
import reliquary.item.ChargeableItem;
import reliquary.item.util.IScrollableItem;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.NoPlayerBlockItemUseContext;
import reliquary.util.TooltipBuilder;

public class SojournerStaffItem
extends ChargeableItem
implements IScrollableItem {
    private static final int COOLDOWN = 10;
    public static final int TORCH_SLOT = 0;

    public SojournerStaffItem(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.EPIC));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 10L != 0L) {
            return;
        }
        if (this.isEnabled(stack)) {
            this.scanForMatchingTorchesToFillInternalStorage(stack, player);
        }
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        if (player.level().isClientSide) {
            return InteractionResult.PASS;
        }
        this.cycleTorchMode(stack, scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    private void scanForMatchingTorchesToFillInternalStorage(ItemStack staff, Player player) {
        this.runOnHandler(staff, handler -> {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stackInSlot = handler.getStackInSlot(slot);
                if (stackInSlot.isEmpty() && slot != 0) continue;
                this.consumeAndCharge(staff, slot, player, (Integer)Config.COMMON.items.sojournerStaff.maxCapacityPerItemType.get() - stackInSlot.getCount(), 1, 16);
            }
            this.consumeAndCharge(staff, handler.getSlots(), player, (Integer)Config.COMMON.items.sojournerStaff.maxCapacityPerItemType.get(), 1, 16);
        });
    }

    public ItemStack getCurrentTorch(ItemStack stack) {
        return this.getFromHandler(stack, handler -> this.getCurrentTorchIndex(stack) < handler.getSlots() ? handler.getStackInSlot(this.getCurrentTorchIndex(stack)) : ItemStack.EMPTY);
    }

    public int getTorchCount(ItemStack stack) {
        return this.getFromHandler(stack, handler -> this.getCurrentTorchIndex(stack) < handler.getSlots() ? handler.getCountInSlot(this.getCurrentTorchIndex(stack)) : 0);
    }

    private void cycleTorchMode(ItemStack stack, boolean next) {
        ItemStack currentTorch = this.getCurrentTorch(stack);
        if (this.getCurrentTorchIndex(stack) != 0 && currentTorch.isEmpty()) {
            return;
        }
        this.runOnHandler(stack, handler -> {
            int slots = handler.getSlots();
            if (slots == 1) {
                return;
            }
            int currentIndex = this.getCurrentTorchIndex(stack);
            stack.set(ModDataComponents.TORCH_INDEX, (Object)((byte)Math.floorMod(currentIndex + (next ? 1 : -1), slots)));
        });
    }

    private int getCurrentTorchIndex(ItemStack stack) {
        return ((Byte)stack.getOrDefault(ModDataComponents.TORCH_INDEX, (Object)0)).byteValue();
    }

    @Override
    protected void addMoreInformation(ItemStack staff, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        StringJoiner joiner = new StringJoiner(";");
        this.runOnHandler(staff, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stackInSlot = handler.getStackInSlot(i);
                if (stackInSlot.isEmpty()) continue;
                joiner.add(stackInSlot.getHoverName().getString() + ": " + stackInSlot.getCount());
            }
        });
        if (this.getTorchCount(staff) > 0) {
            tooltipBuilder.data(this, ".tooltip.contents", joiner.toString());
            tooltipBuilder.data(this, ".tooltip.placing", this.getCurrentTorch(staff).getHoverName().getString());
        }
        if (this.isEnabled(staff)) {
            tooltipBuilder.absorbActive(new ItemStack((ItemLike)Blocks.TORCH).getHoverName().getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.placeTorch(context);
    }

    private InteractionResult placeTorch(UseOnContext context) {
        BlockPos placeBlockAt;
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        ItemStack stack = context.getItemInHand();
        BlockPos blockPos = placeBlockAt = context.getLevel().getBlockState(pos).canBeReplaced() ? pos : pos.relative(face);
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack torch = this.getCurrentTorch(stack);
        if (player == null || torch.isEmpty() || !(torch.getItem() instanceof BlockItem)) {
            return InteractionResult.FAIL;
        }
        if (!player.mayUseItemAt(placeBlockAt, face, stack) || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        player.swing(hand);
        Block blockToPlace = ((BlockItem)torch.getItem()).getBlock();
        NoPlayerBlockItemUseContext placeContext = new NoPlayerBlockItemUseContext(level, placeBlockAt, new ItemStack((ItemLike)blockToPlace), face);
        if (!placeContext.canPlace() || !this.removeTorches(player, stack, placeBlockAt)) {
            return InteractionResult.FAIL;
        }
        ((BlockItem)torch.getItem()).place((BlockPlaceContext)placeContext);
        float gauss = 0.5f + level.random.nextFloat() / 2.0f;
        level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)gauss, (float)gauss, (float)0.0f), (double)placeBlockAt.getX() + 0.5, (double)placeBlockAt.getY() + 0.5, (double)placeBlockAt.getZ() + 0.5, 0.0, 0.0, 0.0);
        return InteractionResult.SUCCESS;
    }

    private boolean removeTorches(Player player, ItemStack staff, BlockPos placeBlockAt) {
        if (!player.isCreative()) {
            int distance = (int)player.getEyePosition(1.0f).distanceTo(new Vec3((double)placeBlockAt.getX(), (double)placeBlockAt.getY(), (double)placeBlockAt.getZ()));
            int cost = 1 + distance / (Integer)Config.COMMON.items.sojournerStaff.tilePerCostMultiplier.get();
            int torchIndex = this.getCurrentTorchIndex(staff);
            return this.useCharge(staff, torchIndex, cost);
        }
        return true;
    }

    public boolean removeTorch(ItemStack stack) {
        return this.useCharge(stack, 0, 1);
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (!player.isShiftKeyDown()) {
            HitResult rayTraceResult = this.longRayTrace(level, player);
            if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
                this.placeTorch(new UseOnContext(player, hand, (BlockHitResult)rayTraceResult));
            } else {
                int inserted;
                ItemStack staff = player.getItemInHand(hand);
                ItemStack torch = this.getCurrentTorch(staff);
                if (torch.getCount() > torch.getMaxStackSize()) {
                    torch = torch.copyWithCount(torch.getMaxStackSize());
                }
                if ((inserted = InventoryHelper.insertIntoInventory(torch, InventoryHelper.getMainInventoryItemHandlerFrom(player))) > 0) {
                    int currentTorchIndex = this.getCurrentTorchIndex(staff);
                    this.extractStoredCharge(staff, currentTorchIndex, inserted);
                    if (currentTorchIndex != 0 && this.getTorchCount(staff) == 0) {
                        this.removeSlot(staff, currentTorchIndex);
                    }
                }
            }
        }
        return super.use(level, player, hand);
    }

    @Override
    public void addStoredCharge(ItemStack containerStack, int slot, int chargeToAdd, @Nullable ItemStack chargeStack) {
        if (chargeStack != null) {
            this.getFromHandler(containerStack, handler -> handler.insertItemOrAddIntoNewSlotIfNoStackMatches(chargeStack));
        }
    }

    @Override
    protected void extractStoredCharge(ItemStack containerStack, int slot, int chargeToExtract) {
        this.getFromHandler(containerStack, handler -> handler.extractItem(slot, chargeToExtract, false));
    }

    @Override
    protected boolean removeSlotWhenEmpty(int slot) {
        return slot != 0;
    }

    @Override
    protected void removeSlot(ItemStack containerStack, int slot) {
        this.runOnHandler(containerStack, handler -> {
            handler.removeSlot(slot);
            if (this.getCurrentTorchIndex(containerStack) >= handler.getSlots()) {
                this.cycleTorchMode(containerStack, false);
            }
        });
    }

    @Override
    public int getStoredCharge(ItemStack containerStack, int slot) {
        return this.getTorchCount(containerStack);
    }

    private HitResult longRayTrace(Level level, Player player) {
        float f = player.getXRot();
        float f1 = player.getYRot();
        Vec3 vec3d = player.getEyePosition(1.0f);
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = ((Integer)Config.COMMON.items.sojournerStaff.maxRange.get()).intValue();
        Vec3 vec3d1 = vec3d.add((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return level.clip(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)player));
    }

    @Override
    protected boolean isItemValidForContainerSlot(ItemStack containerStack, int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        if (slot == 0) {
            return stack.is(Items.TORCH);
        }
        return !stack.is(Items.TORCH) && Config.COMMON.items.sojournerStaff.isTorch(stack) && this.doesNotExistInAnotherSlot(containerStack, slot, stack);
    }

    private boolean doesNotExistInAnotherSlot(ItemStack containerStack, int slot, ItemStack stack) {
        return this.getFromHandler(containerStack, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stackInSlot;
                if (i == slot || (stackInSlot = handler.getStackInSlot(i)).isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    protected int getContainerSlotLimit(int slot) {
        return (Integer)Config.COMMON.items.sojournerStaff.maxCapacityPerItemType.get();
    }
}

