/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import reliquary.entity.potion.ThrownPotion;
import reliquary.item.PotionItemBase;

public class ThrownPotionItem
extends PotionItemBase
implements ProjectileItem {
    public ThrownPotionItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        ThrownPotion e = new ThrownPotion(level, (LivingEntity)player, stack.copy());
        e.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        level.playSound(null, player.blockPosition(), SoundEvents.ARROW_SHOOT, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
        level.addFreshEntity((Entity)e);
        return InteractionResult.PASS;
    }

    public Projectile asProjectile(Level level, Position position, ItemStack stack, Direction direction) {
        return new ThrownPotion(level, position, stack.copy());
    }
}

