/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import reliquary.init.ModDataComponents;
import reliquary.item.ItemBase;
import reliquary.util.RandHelper;

public abstract class ToggleableItem
extends ItemBase {
    protected ToggleableItem(Item.Properties properties, Supplier<Boolean> isDisabled) {
        super(properties, isDisabled);
    }

    protected ToggleableItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(ItemStack stack) {
        return this.isEnabled(stack);
    }

    protected void setCooldown(ItemStack stack, Level level, int cooldown) {
        stack.set(ModDataComponents.COOLDOWN_TIME, (Object)(level.getGameTime() + (long)cooldown));
    }

    protected boolean isInCooldown(ItemStack stack, Level level) {
        return (Long)stack.getOrDefault(ModDataComponents.COOLDOWN_TIME, (Object)0L) > level.getGameTime();
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player.isShiftKeyDown()) {
            this.toggleEnabled(stack);
            player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.2f));
            return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem() || oldStack.hasFoil() != newStack.hasFoil();
    }

    public boolean isEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.ENABLED, (Object)false);
    }

    void toggleEnabled(ItemStack stack) {
        stack.set(ModDataComponents.ENABLED, (Object)(!this.isEnabled(stack) ? 1 : 0));
    }
}

