/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import reliquary.block.PedestalBlock;
import reliquary.init.ModDataComponents;
import reliquary.init.ModItems;
import reliquary.item.ChargeableItem;
import reliquary.item.util.IScrollableItem;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.NoPlayerBlockItemUseContext;
import reliquary.util.RandHelper;
import reliquary.util.TooltipBuilder;
import reliquary.util.TranslationHelper;

public class VoidTearItem
extends ChargeableItem
implements IScrollableItem {
    public VoidTearItem(Item.Properties properties) {
        super(properties);
        NeoForge.EVENT_BUS.addListener(this::onItemPickup);
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.isEmpty(stack) ? 16 : 1;
    }

    @Override
    public boolean isFoil(ItemStack stack) {
        return !Minecraft.getInstance().options.keyShift.isDown() && super.isFoil(stack);
    }

    @Override
    protected void addMoreInformation(ItemStack voidTear, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        ItemStack contents = VoidTearItem.getTearContents(voidTear);
        if (this.isEmpty(voidTear)) {
            return;
        }
        tooltipBuilder.data(this, ".tooltip.mode", Component.translatable((String)(TranslationHelper.transl(this) + ".mode." + this.getMode(voidTear).getSerializedName().toLowerCase())).withStyle(ChatFormatting.YELLOW), Component.translatable((String)(TranslationHelper.translTooltip(this) + ".mode." + this.getMode(voidTear).getSerializedName().toLowerCase())).withStyle(ChatFormatting.GRAY)).description(TranslationHelper.translTooltip(this) + ".mode_change", new Object[0]).charge((Item)this, ".tooltip.tear_quantity", contents.getHoverName().getString(), contents.getCount());
        if (this.isEnabled(voidTear)) {
            tooltipBuilder.absorbActive(contents.getHoverName().getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return !this.isEmpty(stack);
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack voidTear = player.getItemInHand(hand);
        if (!level.isClientSide) {
            BlockHitResult rayTraceResult = VoidTearItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (rayTraceResult != null && rayTraceResult.getType() == HitResult.Type.BLOCK && (InventoryHelper.hasItemHandler(level, rayTraceResult.getBlockPos()) && player.isShiftKeyDown() || this.hasPlaceableBlock(voidTear))) {
                return InteractionResult.PASS;
            }
            if (this.isEmpty(voidTear)) {
                return this.rightClickEmpty(voidTear, player);
            }
            if (this.getItemQuantity(voidTear) == 0) {
                this.setEmpty(voidTear);
                return InteractionResult.SUCCESS.heldItemTransformedTo(voidTear);
            }
            if (player.isShiftKeyDown()) {
                return super.use(level, player, hand);
            }
            IItemHandler playerInventory = InventoryHelper.getMainInventoryItemHandlerFrom(player);
            if (this.attemptToEmptyIntoInventory(voidTear, player, playerInventory)) {
                player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.2f));
                this.setEmpty(voidTear);
                return InteractionResult.SUCCESS.heldItemTransformedTo(voidTear);
            }
        }
        return InteractionResult.PASS;
    }

    private boolean hasPlaceableBlock(ItemStack voidTear) {
        return !this.isEmpty(voidTear) && VoidTearItem.getTearContents(voidTear).getItem() instanceof BlockItem;
    }

    private InteractionResult rightClickEmpty(ItemStack emptyVoidTear, Player player) {
        IItemHandler playerInventory = InventoryHelper.getMainInventoryItemHandlerFrom(player);
        ItemStack target = InventoryHelper.getTargetItem(emptyVoidTear, playerInventory);
        if (!target.isEmpty()) {
            ItemStack filledTear;
            if (emptyVoidTear.getCount() > 1) {
                emptyVoidTear.shrink(1);
                filledTear = new ItemStack((ItemLike)this);
            } else {
                filledTear = emptyVoidTear;
            }
            this.buildTear(filledTear, target, player, playerInventory, true);
            player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.2f));
            if (emptyVoidTear.getCount() == 1) {
                return InteractionResult.SUCCESS.heldItemTransformedTo(filledTear);
            }
            InventoryHelper.addItemToPlayerInventory(player, filledTear);
            return InteractionResult.SUCCESS.heldItemTransformedTo(emptyVoidTear);
        }
        return InteractionResult.PASS;
    }

    private void buildTear(ItemStack voidTear, ItemStack target, Player player, IItemHandler inventory, boolean isPlayerInventory) {
        int quantity = InventoryHelper.getItemQuantity(target, inventory);
        if (isPlayerInventory) {
            if (quantity - target.getMaxStackSize() > 0) {
                InventoryHelper.consumeItem(target, player, target.getMaxStackSize(), quantity - target.getMaxStackSize());
                quantity -= target.getMaxStackSize();
            } else {
                InventoryHelper.consumeItem(target, player, 0, 1);
                quantity = 1;
            }
        } else {
            quantity = InventoryHelper.tryToRemoveFromInventory(target, inventory, (Integer)Config.COMMON.items.voidTear.itemLimit.get());
        }
        this.setItemStack(voidTear, target);
        this.setItemQuantity(voidTear, quantity);
        if (((Boolean)Config.COMMON.items.voidTear.absorbWhenCreated.get()).booleanValue()) {
            this.toggleEnabled(voidTear);
        }
    }

    public void inventoryTick(ItemStack voidTear, Level level, Entity entity, int slotNumber, boolean isSelected) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 5L != 0L) {
            return;
        }
        if (this.isEnabled(voidTear)) {
            if (this.isEmpty(voidTear)) {
                this.setEmpty(voidTear);
                return;
            }
            ItemStack contents = VoidTearItem.getTearContents(voidTear);
            if (!contents.isEmpty()) {
                this.fillTear(voidTear, player, contents);
            } else {
                this.setEmpty(voidTear);
            }
        }
    }

    private void fillTear(ItemStack voidTear, Player player, ItemStack contents) {
        IItemHandler playerInventory = InventoryHelper.getMainInventoryItemHandlerFrom(player);
        int itemQuantity = InventoryHelper.getItemQuantity(contents, playerInventory);
        if (this.getItemQuantity(voidTear) <= (Integer)Config.COMMON.items.voidTear.itemLimit.get() && itemQuantity > this.getKeepQuantity(voidTear) && InventoryHelper.consumeItem(contents, player, this.getKeepQuantity(voidTear), itemQuantity - this.getKeepQuantity(voidTear)) && !player.isCreative()) {
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) + itemQuantity - this.getKeepQuantity(voidTear));
        }
        if (this.getMode(voidTear) != Mode.NO_REFILL) {
            this.attemptToReplenish(player, voidTear);
        }
    }

    private void attemptToReplenish(Player player, ItemStack voidTear) {
        int slot;
        IItemHandler playerInventory = InventoryHelper.getMainInventoryItemHandlerFrom(player);
        if (this.fillFirstFirstStackFound(voidTear, playerInventory)) {
            return;
        }
        while (this.getItemQuantity(voidTear) > 1 && (slot = player.getInventory().getFreeSlot()) != -1) {
            ItemStack newStack = VoidTearItem.getTearContents(voidTear).copy();
            int quantityToDecrease = Math.min(newStack.getMaxStackSize(), this.getItemQuantity(voidTear) - 1);
            newStack.setCount(quantityToDecrease);
            player.getInventory().setItem(slot, newStack);
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
            if (this.getMode(voidTear) == Mode.FULL_INVENTORY) continue;
            return;
        }
    }

    private boolean fillFirstFirstStackFound(ItemStack voidTear, IItemHandler h) {
        for (int slot = 0; slot < h.getSlots(); ++slot) {
            ItemStack stackFound = h.getStackInSlot(slot);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stackFound, (ItemStack)VoidTearItem.getTearContents(voidTear))) continue;
            int quantityToDecrease = Math.min(stackFound.getMaxStackSize() - stackFound.getCount(), this.getItemQuantity(voidTear) - 1);
            stackFound.grow(quantityToDecrease);
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
            if (this.getMode(voidTear) == Mode.FULL_INVENTORY) continue;
            return true;
        }
        return false;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Direction face;
        ItemStack containerItem;
        BlockItem itemBlock;
        NoPlayerBlockItemUseContext noPlayerBlockItemUseContext;
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        InteractionHand hand = context.getHand();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack voidTear = player.getItemInHand(hand);
        if (level.getBlockState(pos).getBlock() instanceof PedestalBlock) {
            return InteractionResult.PASS;
        }
        IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (handler != null) {
            return this.processItemHandlerInteraction(player, hand, level, voidTear, handler);
        }
        if (!level.isClientSide && this.hasPlaceableBlock(voidTear) && this.getItemQuantity(voidTear) > 0 && (noPlayerBlockItemUseContext = new NoPlayerBlockItemUseContext(level, pos, new ItemStack((ItemLike)(itemBlock = (BlockItem)(containerItem = VoidTearItem.getTearContents(voidTear)).getItem())), face = context.getClickedFace())).canPlace() && itemBlock.place((BlockPlaceContext)noPlayerBlockItemUseContext).consumesAction()) {
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - 1);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult processItemHandlerInteraction(Player player, InteractionHand hand, Level level, ItemStack voidTear, IItemHandler itemHandler) {
        if (!level.isClientSide) {
            if (this.isEmpty(voidTear)) {
                return this.onItemUseFirstEmpty(voidTear, itemHandler, player, hand);
            }
            if (this.isEnabled(voidTear)) {
                this.drainInventory(voidTear, player, itemHandler);
            } else {
                this.emptyIntoInventory(player, hand, voidTear, itemHandler);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void emptyIntoInventory(Player player, InteractionHand hand, ItemStack voidTear, IItemHandler itemHandler) {
        if (this.attemptToEmptyIntoInventory(voidTear, player, itemHandler)) {
            this.setEmpty(voidTear);
            player.setItemInHand(hand, voidTear);
        }
    }

    private InteractionResult onItemUseFirstEmpty(ItemStack emptyVoidTear, IItemHandler inventory, Player player, InteractionHand hand) {
        ItemStack target = InventoryHelper.getTargetItem(emptyVoidTear, inventory);
        if (!target.isEmpty()) {
            ItemStack filledTear;
            if (emptyVoidTear.getCount() > 1) {
                emptyVoidTear.shrink(1);
                filledTear = new ItemStack((ItemLike)this);
            } else {
                filledTear = emptyVoidTear;
            }
            this.buildTear(filledTear, target, player, inventory, false);
            player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.2f));
            if (emptyVoidTear.getCount() == 1) {
                player.setItemInHand(hand, filledTear);
            } else {
                InventoryHelper.addItemToPlayerInventory(player, filledTear);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean attemptToEmptyIntoInventory(ItemStack stack, Player player, IItemHandler inventory) {
        int maxNumberToEmpty;
        ItemStack contents = VoidTearItem.getTearContents(stack).copy();
        contents.setCount(1);
        int quantity = this.getItemQuantity(stack);
        int n = maxNumberToEmpty = player.isShiftKeyDown() ? quantity : Math.min(contents.getMaxStackSize(), quantity);
        if ((quantity -= InventoryHelper.tryToAddToInventory(contents, inventory, maxNumberToEmpty)) == 0) {
            player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.8f));
            return true;
        }
        this.setItemQuantity(stack, quantity);
        player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.2f));
        return false;
    }

    private void drainInventory(ItemStack stack, Player player, IItemHandler inventory) {
        ItemStack contents = VoidTearItem.getTearContents(stack);
        int quantity = this.getItemQuantity(stack);
        int quantityDrained = InventoryHelper.tryToRemoveFromInventory(contents, inventory, (Integer)Config.COMMON.items.voidTear.itemLimit.get() - quantity);
        if (quantityDrained <= 0) {
            return;
        }
        player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.2f));
        this.setItemQuantity(stack, quantity + quantityDrained);
    }

    public static ItemStack getTearContents(ItemStack voidTear) {
        return ModItems.VOID_TEAR.get().getFromHandler(voidTear, handler -> handler.getStackInSlot(0));
    }

    @Override
    protected int getContainerSlotLimit(ItemStack stack, int slot) {
        return this.getItemQuantity(stack) == 0 ? 0 : (Integer)Config.COMMON.items.voidTear.itemLimit.get();
    }

    @Override
    protected boolean isItemValidForContainerSlot(ItemStack containerStack, int slot, ItemStack stack) {
        return this.getFromHandler(containerStack, handler -> handler.getStackInSlot(0).isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)VoidTearItem.getTearContents(containerStack), (ItemStack)stack));
    }

    @Override
    public void addStoredCharge(ItemStack containerStack, int slot, int chargeToAdd, @Nullable ItemStack chargeStack) {
        if (slot > 0) {
            return;
        }
        this.runOnHandler(containerStack, handler -> {
            ItemStack currentStack = handler.getStackInSlot(0);
            if (currentStack.isEmpty()) {
                if (chargeStack != null) {
                    handler.setStackInSlot(slot, chargeStack);
                }
                return;
            }
            currentStack.setCount(Math.min((Integer)Config.COMMON.items.voidTear.itemLimit.get(), currentStack.getCount() + chargeToAdd));
            handler.setStackInSlot(0, currentStack);
        });
    }

    @Override
    public int getStoredCharge(ItemStack containerStack, int slot) {
        return slot == 0 ? this.getItemQuantity(containerStack) : 0;
    }

    private void setItemStack(ItemStack voidTear, ItemStack stack) {
        this.runOnHandler(voidTear, handler -> handler.setStackInSlot(0, stack));
    }

    private void setItemQuantity(ItemStack voidTear, int quantity) {
        this.runOnHandler(voidTear, handler -> {
            ItemStack stack = handler.getStackInSlot(0);
            stack.setCount(quantity);
            handler.setStackInSlot(0, stack);
        });
    }

    private int getItemQuantity(ItemStack voidTear) {
        return this.getFromHandler(voidTear, handler -> handler.getCountInSlot(0));
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack voidTear, Player player, double scrollDelta) {
        if (player.level().isClientSide) {
            return InteractionResult.PASS;
        }
        this.cycleMode(voidTear, scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    public Mode getMode(ItemStack voidTear) {
        return (Mode)((Object)voidTear.getOrDefault(ModDataComponents.VOID_TEAR_MODE, (Object)Mode.ONE_STACK));
    }

    private void setMode(ItemStack voidTear, Mode mode) {
        voidTear.set(ModDataComponents.VOID_TEAR_MODE, (Object)mode);
    }

    private void cycleMode(ItemStack voidTear, boolean next) {
        if (this.isEmpty(voidTear)) {
            return;
        }
        if (next) {
            this.setMode(voidTear, this.getMode(voidTear).next());
        } else {
            this.setMode(voidTear, this.getMode(voidTear).previous());
        }
    }

    private int getKeepQuantity(ItemStack voidTear) {
        Mode mode = this.getMode(voidTear);
        if (mode == Mode.NO_REFILL) {
            return 0;
        }
        if (mode == Mode.ONE_STACK) {
            return VoidTearItem.getTearContents(voidTear).getMaxStackSize();
        }
        return Integer.MAX_VALUE;
    }

    private void onItemPickup(ItemEntityPickupEvent.Pre event) {
        ItemStack tearStack;
        ItemStack pickedUpStack = event.getItemEntity().getItem();
        Player player = event.getPlayer();
        ItemEntity itemEntity = event.getItemEntity();
        for (int slot = 0; !(slot >= player.getInventory().getContainerSize() || (tearStack = player.getInventory().getItem(slot)).getItem() == this && this.isEnabled(tearStack) && this.tryToPickupWithTear(event, pickedUpStack, player, itemEntity, tearStack)); ++slot) {
        }
    }

    private boolean tryToPickupWithTear(ItemEntityPickupEvent.Pre event, ItemStack pickedUpStack, Player player, ItemEntity itemEntity, ItemStack tearStack) {
        IItemHandler playerInventory;
        int playerItemQuantity;
        int tearItemQuantity = this.getItemQuantity(tearStack);
        if (this.canAbsorbStack(pickedUpStack, tearStack) && ((playerItemQuantity = InventoryHelper.getItemQuantity(pickedUpStack, playerInventory = InventoryHelper.getMainInventoryItemHandlerFrom(player))) + pickedUpStack.getCount() >= this.getKeepQuantity(tearStack) || player.getInventory().getFreeSlot() == -1)) {
            this.setItemQuantity(tearStack, tearItemQuantity + pickedUpStack.getCount());
            if (!itemEntity.isSilent()) {
                RandomSource rand = itemEntity.level().random;
                itemEntity.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne(rand) * 0.7f + 1.0f) * 2.0f);
            }
            itemEntity.discard();
            event.setCanPickup(TriState.FALSE);
            return true;
        }
        return false;
    }

    boolean canAbsorbStack(ItemStack pickedUpStack, ItemStack tearStack) {
        return ItemStack.isSameItemSameComponents((ItemStack)VoidTearItem.getTearContents(tearStack), (ItemStack)pickedUpStack) && this.getItemQuantity(tearStack) + pickedUpStack.getCount() <= (Integer)Config.COMMON.items.voidTear.itemLimit.get();
    }

    public boolean isEmpty(ItemStack voidTear) {
        return !voidTear.has(ModDataComponents.ENABLED) || this.getItemQuantity(voidTear) == 0;
    }

    private void setEmpty(ItemStack voidTear) {
        voidTear.remove(ModDataComponents.ENABLED);
        this.removeContainerContents(voidTear);
    }

    public static enum Mode implements StringRepresentable
    {
        ONE_STACK,
        FULL_INVENTORY,
        NO_REFILL;

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Mode> STREAM_CODEC;
        private static final Mode[] VALUES;

        public String getSerializedName() {
            return this.name();
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public Mode previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Mode.class);
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode value : Mode.values()) {
                builder.put((Object)value.getSerializedName(), (Object)value);
            }
            VALUES = Mode.values();
        }
    }
}

