/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import reliquary.init.ModBlocks;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.reference.Settings;

public class FertileLilyPadBlock
extends BushBlock
implements ICreativeTabItemGenerator {
    private static final Map<ResourceKey<Level>, Long> currentDimensionTicks = new HashMap<ResourceKey<Level>, Long>();
    private static final Map<ResourceKey<Level>, Set<BlockPos>> dimensionPositionsTicked = new HashMap<ResourceKey<Level>, Set<BlockPos>>();
    private static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.WATER;
    }

    public FertileLilyPadBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60977_());
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        ResourceKey dimKey = world.m_46472_();
        if (!currentDimensionTicks.containsKey(dimKey) || currentDimensionTicks.get(dimKey).longValue() != world.m_46467_()) {
            currentDimensionTicks.put((ResourceKey<Level>)dimKey, world.m_46467_());
            dimensionPositionsTicked.put((ResourceKey<Level>)dimKey, new HashSet());
        } else if (dimensionPositionsTicked.computeIfAbsent((ResourceKey<Level>)dimKey, k -> new HashSet()).contains(pos)) {
            return;
        }
        this.growCropsNearby(world, pos, state);
        dimensionPositionsTicked.computeIfAbsent((ResourceKey<Level>)dimKey, k -> new HashSet()).add(pos);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        world.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5 + rand.m_188583_() / 8.0, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5 + rand.m_188583_() / 8.0, 0.0, 0.9, 0.5);
    }

    private int secondsBetweenGrowthTicks() {
        return (Integer)Settings.COMMON.blocks.fertileLilypad.secondsBetweenGrowthTicks.get();
    }

    private int tileRange() {
        return (Integer)Settings.COMMON.blocks.fertileLilypad.tileRange.get();
    }

    private int fullPotencyRange() {
        return (Integer)Settings.COMMON.blocks.fertileLilypad.fullPotencyRange.get();
    }

    private void growCropsNearby(ServerLevel world, BlockPos pos, BlockState state) {
        BlockPos.m_121940_((BlockPos)pos.m_7918_(-this.tileRange(), -this.tileRange(), -this.tileRange()), (BlockPos)pos.m_7918_(this.tileRange(), this.tileRange(), this.tileRange())).forEach(cropPos -> {
            float chanceToGrow;
            if (!world.m_46805_(cropPos)) {
                return;
            }
            BlockPos posDiff = cropPos.m_121996_((Vec3i)pos);
            int distance = Math.max(Math.abs(posDiff.m_123341_()), Math.max(Math.abs(posDiff.m_123342_()), Math.abs(posDiff.m_123343_())));
            float f = chanceToGrow = distance <= this.fullPotencyRange() ? 1.0f : 1.0f - (float)(distance - this.fullPotencyRange()) / (float)(this.tileRange() - this.fullPotencyRange() + 1);
            if (world.f_46441_.m_188501_() > chanceToGrow) {
                return;
            }
            BlockState cropState = world.m_8055_(cropPos);
            Block cropBlock = cropState.m_60734_();
            if (this.isAllowedCropBlock(cropBlock) && this.isGrowable(cropBlock)) {
                this.tickCropBlock(world, (BlockPos)cropPos, cropState, distance);
            }
        });
        world.m_186460_(pos, state.m_60734_(), this.secondsBetweenGrowthTicks() * 20 / this.getNumberOfPotencySteps());
    }

    private boolean isAllowedCropBlock(Block cropBlock) {
        return cropBlock != ModBlocks.FERTILE_LILY_PAD.get() && cropBlock != Blocks.f_50440_ && cropBlock != Blocks.f_50034_;
    }

    private boolean isGrowable(Block cropBlock) {
        if (cropBlock == Blocks.f_50491_) {
            return true;
        }
        return cropBlock instanceof IPlantable || cropBlock instanceof BonemealableBlock || cropBlock.m_5456_().m_204114_().m_203656_(Tags.Items.CROPS);
    }

    private int getNumberOfPotencySteps() {
        return this.tileRange() - this.fullPotencyRange() + 1;
    }

    private void tickCropBlock(ServerLevel level, BlockPos cropPos, BlockState cropState, int distance) {
        float randomTickChance = 1.0f;
        Block block = cropState.m_60734_();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            randomTickChance = 0.5f;
            if (bonemealableBlock.m_7370_((LevelReader)level, cropPos, cropState, false) && level.f_46441_.m_188501_() < 0.01f) {
                bonemealableBlock.m_214148_(level, level.f_46441_, cropPos, cropState);
            }
        }
        if (level.f_46441_.m_188501_() <= randomTickChance) {
            BlockState cropStateAfter;
            cropState.m_222972_(level, cropPos, level.f_46441_);
            if (level.f_46441_.m_188501_() < 0.2f && cropState != (cropStateAfter = level.m_8055_(cropPos))) {
                level.m_46796_(1505, cropPos, Math.max(this.tileRange() - distance, 1));
            }
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (entityIn instanceof Boat) {
            worldIn.m_46961_(pos, true);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        FluidState ifluidstate = worldIn.m_6425_(pos);
        return ifluidstate.m_76152_() == Fluids.f_76193_ || state.m_60734_() instanceof IceBlock;
    }
}

