/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entity.shot.ShotEntityBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class NeutralShotEntity
extends ShotEntityBase {
    public NeutralShotEntity(EntityType<NeutralShotEntity> entityType, Level world) {
        super(entityType, world);
    }

    public NeutralShotEntity(Level world, Player player, InteractionHand hand) {
        super((EntityType)ModEntities.NEUTRAL_SHOT.get(), world, player, hand);
    }

    @Override
    int getRicochetMax() {
        return 1;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 8 + this.d6();
    }

    @Override
    void doFiringEffects() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123744_);
    }

    @Override
    void doFlightEffects() {
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123808_);
        }
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.NEUTRAL;
    }
}

