/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import reliquary.item.ToggleableItem;
import reliquary.item.util.ICuriosItem;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.MobHelper;

public class TwilightCloakItem
extends ToggleableItem
implements ICuriosItem {
    public TwilightCloakItem() {
        super(new Item.Properties().m_41487_(1));
        MinecraftForge.EVENT_BUS.addListener(this::onEntityTargetedEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingUpdate);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public void m_6883_(ItemStack twilightCloak, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof Player)) {
            return;
        }
        this.updateInvisibility(twilightCloak, (Player)entity);
    }

    private void updateInvisibility(ItemStack twilightCloak, Player player) {
        if (!this.isEnabled(twilightCloak)) {
            return;
        }
        if (player.m_9236_().m_46803_(player.m_20183_()) > (Integer)Settings.COMMON.items.twilightCloak.maxLightLevel.get()) {
            return;
        }
        MobEffectInstance quickInvisibility = new MobEffectInstance(MobEffects.f_19609_, 2, 0, false, false);
        player.m_7292_(quickInvisibility);
    }

    @Override
    public ICuriosItem.Type getCuriosType() {
        return ICuriosItem.Type.BODY;
    }

    @Override
    public void onWornTick(ItemStack twilightCloak, LivingEntity player) {
        this.updateInvisibility(twilightCloak, (Player)player);
    }

    private void onEntityTargetedEvent(LivingChangeTargetEvent event) {
        if (this.shouldResetTarget((Entity)event.getNewTarget())) {
            event.setCanceled(true);
        }
    }

    private void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        this.doTwilightCloakCheck((LivingEvent)event);
    }

    private void doTwilightCloakCheck(LivingEvent event) {
        Mob entityLiving;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && this.shouldResetTarget((Entity)(entityLiving = (Mob)livingEntity).m_5448_())) {
            MobHelper.resetTarget(entityLiving);
        }
    }

    private boolean shouldResetTarget(@Nullable Entity target) {
        if (!(target instanceof Player)) {
            return false;
        }
        Player player = (Player)target;
        return InventoryHelper.playerHasItem(player, this, true, ICuriosItem.Type.BODY) && player.m_9236_().m_46803_(player.m_20183_()) <= (Integer)Settings.COMMON.items.twilightCloak.maxLightLevel.get();
    }
}

