/*
 * Decompiled with CFR 0.152.
 */
package reliquary.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import reliquary.item.util.IScrollableItem;

public class ScrolledItemPacket {
    private final double scrollDelta;

    public ScrolledItemPacket(double scrollDelta) {
        this.scrollDelta = scrollDelta;
    }

    static void encode(ScrolledItemPacket msg, FriendlyByteBuf buffer) {
        buffer.writeDouble(msg.scrollDelta);
    }

    static ScrolledItemPacket decode(FriendlyByteBuf packetBuffer) {
        return new ScrolledItemPacket(packetBuffer.readDouble());
    }

    static void onMessage(ScrolledItemPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ScrolledItemPacket.handleMessage(msg, ((NetworkEvent.Context)contextSupplier.get()).getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(ScrolledItemPacket msg, ServerPlayer sender) {
        ItemStack stack = sender.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof IScrollableItem) {
            IScrollableItem leftClickableItem = (IScrollableItem)item;
            leftClickableItem.onMouseScrolled(stack, (Player)sender, msg.scrollDelta);
        }
    }
}

