/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import reliquary.block.tile.BlockEntityBase;
import reliquary.init.ModBlocks;
import reliquary.util.InventoryHelper;
import reliquary.util.WorldHelper;

public class PassivePedestalBlockEntity
extends BlockEntityBase {
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            if (PassivePedestalBlockEntity.this.level != null && !((PassivePedestalBlockEntity)PassivePedestalBlockEntity.this).level.isClientSide) {
                PassivePedestalBlockEntity.this.setChangedAndNotifyBlock();
            }
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack item = this.getStackInSlot(0).copy();
            ItemStack result = super.extractItem(slot, amount, simulate);
            if (this.getStackInSlot(0).isEmpty()) {
                PassivePedestalBlockEntity.this.onItemRemoved(item);
            }
            return result;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            ItemStack item = this.getStackInSlot(0).copy();
            super.setStackInSlot(slot, stack);
            if (this.getStackInSlot(0).isEmpty()) {
                PassivePedestalBlockEntity.this.onItemRemoved(item);
            } else {
                PassivePedestalBlockEntity.this.onItemAdded();
            }
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            boolean wasEmpty = this.getStackInSlot(0).isEmpty();
            ItemStack result = super.insertItem(slot, stack, simulate);
            if (wasEmpty && !this.getStackInSlot(0).isEmpty()) {
                PassivePedestalBlockEntity.this.onItemAdded();
            }
            return result;
        }
    };

    public ItemStack getItem() {
        return this.itemHandler.getStackInSlot(0);
    }

    public void setItem(ItemStack item) {
        this.itemHandler.setStackInSlot(0, item);
    }

    protected void onItemRemoved(ItemStack itemBeingRemoved) {
    }

    protected void onItemAdded() {
    }

    public PassivePedestalBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.PASSIVE_PEDESTAL_TILE_TYPE.get(), pos, state);
    }

    PassivePedestalBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void dropPedestalInventory(Level level) {
        InventoryHelper.dropInventoryItems(level, this.worldPosition, (IItemHandler)this.itemHandler);
    }

    public void removeAndSpawnItem(Level level) {
        ItemStack item = this.itemHandler.getStackInSlot(0);
        if (!item.isEmpty()) {
            if (!level.isClientSide) {
                this.setChanged();
                ItemEntity itemEntity = new ItemEntity(level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5, item);
                level.addFreshEntity((Entity)itemEntity);
                WorldHelper.notifyBlockUpdate(this);
            }
            this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
        }
    }

    private void setChangedAndNotifyBlock() {
        if (this.level == null) {
            return;
        }
        this.setChanged();
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.setStackInSlot(0, tag.contains("item") ? ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("item")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        ItemStack item = this.getItem();
        if (!item.isEmpty()) {
            compound.put("item", item.save(registries));
        }
    }
}

