/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import reliquary.init.ModEntities;

public class EnderStaffProjectile
extends ThrowableProjectile
implements ItemSupplier {
    private boolean normalGravity = false;

    public EnderStaffProjectile(EntityType<EnderStaffProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public EnderStaffProjectile(Level level, Player entityPlayer, boolean shortRange) {
        super(ModEntities.ENDER_STAFF_PROJECTILE.get(), (LivingEntity)entityPlayer, level);
        this.normalGravity = shortRange;
    }

    protected double getDefaultGravity() {
        if (this.normalGravity) {
            return super.getDefaultGravity();
        }
        return 0.005f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 4 == this.level().random.nextInt(5)) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 1.0);
        }
        if (this.isInWater()) {
            this.onThrowableCollision((HitResult)new BlockHitResult(this.position(), Direction.UP, this.blockPosition(), true));
        }
    }

    protected void checkInsideBlocks() {
        super.checkInsideBlocks();
        Vec3 deltaMovement = this.getDeltaMovement();
        double tinyScaleUp = 1.008;
        this.setDeltaMovement(deltaMovement.x * tinyScaleUp, deltaMovement.y, deltaMovement.z * tinyScaleUp);
    }

    protected void onHit(HitResult result) {
        this.onThrowableCollision(result);
    }

    private void onThrowableCollision(HitResult result) {
        Entity thrower = this.getOwner();
        if (!(thrower instanceof Player) || (int)this.getY() <= 0) {
            this.discard();
            return;
        }
        for (int i = 0; i < 32; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
        }
        if (!this.level().isClientSide) {
            thrower.fallDistance = 0.0f;
            int x = (int)Math.round(this.getX());
            int y = (int)Math.round(this.getY());
            int z = (int)Math.round(this.getZ());
            if (result.getType() != HitResult.Type.MISS) {
                BlockPos pos;
                if (result.getType() == HitResult.Type.ENTITY) {
                    Entity entityHit = ((EntityHitResult)result).getEntity();
                    entityHit.hurt(this.damageSources().thrown((Entity)this, thrower), 0.0f);
                    pos = entityHit.blockPosition();
                } else {
                    BlockHitResult blockResult = (BlockHitResult)result;
                    pos = blockResult.getBlockPos().relative(blockResult.getDirection());
                }
                y = pos.getY();
                x = pos.getX();
                z = pos.getZ();
            }
            float targetX = (float)x + 0.5f;
            float targetY = (float)y + 0.5f;
            float targetZ = (float)z + 0.5f;
            if (thrower instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)thrower;
                EventHooks.onEnderPearlLand((ServerPlayer)serverPlayer, (double)targetX, (double)targetY, (double)targetZ, (ThrownEnderpearl)new ThrownEnderpearl(this.level(), (LivingEntity)serverPlayer), (float)0.0f, (HitResult)result);
            }
            thrower.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            thrower.teleportTo((double)targetX, (double)targetY, (double)targetZ);
        }
        this.discard();
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)Items.ENDER_PEARL);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("normalGravity", this.normalGravity);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.normalGravity = tag.getBoolean("normalGravity");
    }
}

