/*
 * Decompiled with CFR 0.152.
 */
package reliquary.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import reliquary.Reliquary;

public record SpawnThrownPotionImpactParticlesPayload(int color, double posX, double posY, double posZ) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpawnThrownPotionImpactParticlesPayload> TYPE = new CustomPacketPayload.Type(Reliquary.getRL("thrown_potion_impact_particles"));
    public static final StreamCodec<FriendlyByteBuf, SpawnThrownPotionImpactParticlesPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SpawnThrownPotionImpactParticlesPayload::color, (StreamCodec)ByteBufCodecs.DOUBLE, SpawnThrownPotionImpactParticlesPayload::posX, (StreamCodec)ByteBufCodecs.DOUBLE, SpawnThrownPotionImpactParticlesPayload::posY, (StreamCodec)ByteBufCodecs.DOUBLE, SpawnThrownPotionImpactParticlesPayload::posZ, SpawnThrownPotionImpactParticlesPayload::new);

    public static void handlePayload(SpawnThrownPotionImpactParticlesPayload payload) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        RandomSource rand = mc.level.random;
        float red = (float)(payload.color >> 16 & 0xFF) / 256.0f;
        float green = (float)(payload.color >> 8 & 0xFF) / 256.0f;
        float blue = (float)(payload.color & 0xFF) / 256.0f;
        for (int i = 0; i < 100; ++i) {
            double var39 = rand.nextDouble() * 4.0;
            double angle = rand.nextDouble() * Math.PI * 2.0;
            double xSpeed = Math.cos(angle) * var39;
            double ySpeed = 0.01 + rand.nextDouble() * 0.5;
            double zSpeed = Math.sin(angle) * var39;
            Particle particle = mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.EFFECT, payload.posX + xSpeed * 0.1, payload.posY + 0.3, payload.posZ + zSpeed * 0.1, xSpeed, ySpeed, zSpeed);
            if (particle == null) continue;
            float var32 = 0.75f + rand.nextFloat() * 0.25f;
            particle.setColor(red * var32, green * var32, blue * var32);
            particle.setPower((float)var39);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

