/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block;

import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import reliquary.block.tile.PassivePedestalBlockEntity;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.WorldHelper;

public class PassivePedestalBlock
extends Block
implements EntityBlock,
ICreativeTabItemGenerator,
SimpleWaterloggedBlock {
    static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)3.5, (double)9.0, (double)4.0, (double)4.0, (double)10.0, (double)12.0), Block.box((double)12.0, (double)9.0, (double)4.0, (double)12.5, (double)10.0, (double)12.0), Block.box((double)3.5, (double)9.0, (double)3.5, (double)12.5, (double)10.0, (double)4.0), Block.box((double)3.5, (double)9.0, (double)12.0, (double)12.5, (double)10.0, (double)12.5), Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public PassivePedestalBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.STONE).strength(1.5f, 2.0f).forceSolidOn());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (this.isDisabled()) {
            return;
        }
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    protected boolean isDisabled() {
        return Boolean.TRUE.equals(Config.COMMON.disable.disablePassivePedestal.get());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() == null) {
            return this.defaultBlockState();
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getPlayer().getDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return Boolean.TRUE.equals(state.getValue((Property)WATERLOGGED)) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction != Direction.DOWN && Boolean.TRUE.equals(state.getValue((Property)WATERLOGGED))) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return player.isCrouching() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return (InteractionResult)WorldHelper.getBlockEntity((BlockGetter)level, pos, PassivePedestalBlockEntity.class).map(pedestal -> {
            if (player.isCrouching()) {
                pedestal.removeAndSpawnItem(level);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }).orElse((Record)InteractionResult.FAIL);
    }

    protected InteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (heldItem.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, pos, PassivePedestalBlockEntity.class).map(pedestal -> (InteractionResult)InventoryHelper.executeOnItemHandlerAt(level, pos, state, pedestal, itemHandler -> InventoryHelper.tryAddingPlayerCurrentItem(player, itemHandler, InteractionHand.MAIN_HAND) ? InteractionResult.SUCCESS : InteractionResult.CONSUME, InteractionResult.CONSUME)).orElse((InteractionResult)InteractionResult.FAIL);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState result = super.playerWillDestroy(level, pos, state, player);
        WorldHelper.getBlockEntity((BlockGetter)level, pos, PassivePedestalBlockEntity.class).ifPresent(pedestal -> pedestal.dropPedestalInventory(level));
        return result;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PassivePedestalBlockEntity(pos, state);
    }

    public static void onRightClicked(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player.level().isClientSide() || !player.isCrouching() || !player.getMainHandItem().isEmpty() || player.getOffhandItem().isEmpty()) {
            return;
        }
        Block block = player.level().getBlockState(event.getPos()).getBlock();
        if (!(block instanceof PassivePedestalBlock)) {
            return;
        }
        PassivePedestalBlockEntity pedestal = (PassivePedestalBlockEntity)player.level().getBlockEntity(event.getPos());
        if (pedestal != null) {
            pedestal.removeAndSpawnItem(player.level());
        }
        event.setCanceled(true);
    }
}

