/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import reliquary.block.PassivePedestalBlock;
import reliquary.block.tile.PedestalBlockEntity;
import reliquary.init.ModBlocks;
import reliquary.pedestal.PedestalRegistry;
import reliquary.reference.Config;
import reliquary.util.BlockEntityHelper;
import reliquary.util.WorldHelper;

public class PedestalBlock
extends PassivePedestalBlock {
    public static final BooleanProperty ENABLED = BooleanProperty.create((String)"enabled");
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.box((double)3.5, (double)9.0, (double)12.0, (double)12.5, (double)10.0, (double)12.5), Block.box((double)3.5, (double)9.0, (double)3.5, (double)12.5, (double)10.0, (double)4.0), Block.box((double)12.0, (double)9.0, (double)4.0, (double)12.5, (double)10.0, (double)12.0), Block.box((double)3.5, (double)9.0, (double)4.0, (double)4.0, (double)10.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public PedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ENABLED});
    }

    @Override
    protected boolean isDisabled() {
        return Boolean.TRUE.equals(Config.COMMON.disable.disablePedestal.get());
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(level.dimension().registry(), pos, 160);
        for (BlockPos pedestalPosition : pedestalPositions) {
            WorldHelper.getBlockEntity((BlockGetter)level, pedestalPosition, PedestalBlockEntity.class).ifPresent(pedestalBlockEntity -> pedestalBlockEntity.updateRedstone(level));
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PedestalBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return null;
        }
        return BlockEntityHelper.createTickerHelper(blockEntityType, ModBlocks.PEDESTAL_TILE_TYPE.get(), (l, p, s, be) -> be.serverTick(l));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
        ((PedestalBlockEntity)level.getBlockEntity(pos)).neighborUpdate(level);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (Boolean.TRUE.equals(state.getValue((Property)ENABLED)) && rand.nextInt(2) == 1) {
            Direction dir = Direction.from2DDataValue((int)rand.nextInt(4));
            double xMiddle = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.0625 + rand.nextDouble() * 4.0 / 16.0;
            double zMiddle = (double)pos.getZ() + 0.5;
            double sideOffset = 0.25 + rand.nextDouble() * 2.0 / 16.0;
            double alongTheSideOffset = rand.nextDouble() * 6.0 / 16.0;
            Vec3i normal = dir.getUnitVec3i();
            level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, xMiddle + (double)normal.getX() * sideOffset + (double)normal.getZ() * alongTheSideOffset, y, zMiddle + (double)normal.getZ() * sideOffset + (double)normal.getX() * alongTheSideOffset, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isCrouching()) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, pos, PedestalBlockEntity.class).map(pedestal -> {
            if (this.switchClicked(hitResult.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()))) {
                pedestal.toggleSwitch(level);
                return InteractionResult.SUCCESS;
            }
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }).orElse((InteractionResult)InteractionResult.FAIL);
    }

    private boolean switchClicked(Vec3 hitVec) {
        double xOff = hitVec.x();
        double yOff = hitVec.y();
        double zOff = hitVec.z();
        return yOff >= 0.0625 && yOff <= 0.25 && xOff >= 0.25 && xOff <= 0.75 && zOff >= 0.25 && zOff <= 0.75;
    }

    @Override
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState result = super.playerWillDestroy(level, pos, state, player);
        PedestalRegistry.unregisterPosition(level.dimension().registry(), pos);
        WorldHelper.getBlockEntity((BlockGetter)level, pos, PedestalBlockEntity.class).ifPresent(pedestal -> pedestal.removeAndSpawnItem(level));
        return result;
    }
}

