/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import reliquary.block.tile.BlockEntityBase;
import reliquary.compat.jade.provider.IJadeDataChangeIndicator;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.util.InventoryHelper;
import reliquary.util.WorldHelper;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionIngredient;

public class ApothecaryMortarBlockEntity
extends BlockEntityBase
implements IJadeDataChangeIndicator {
    public static final int PESTLE_USAGE_MAX = 5;
    private int pestleUsedCounter = 0;
    private boolean dataChanged = true;
    private long finishCoolDown;
    private final ItemStackHandler items = new ItemStackHandler(3){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.isItemValid(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        private boolean isItemValid(ItemStack stack) {
            if (PotionHelper.isItemEssence(stack)) {
                return true;
            }
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).isEmpty() || this.getStackInSlot(i).getItem() != stack.getItem()) continue;
                return false;
            }
            return PotionHelper.isIngredient(stack);
        }

        protected void onContentsChanged(int slot) {
            ApothecaryMortarBlockEntity.this.dataChanged = true;
            WorldHelper.notifyBlockUpdate(ApothecaryMortarBlockEntity.this);
        }
    };

    public ApothecaryMortarBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.APOTHECARY_MORTAR_TILE_TYPE.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.deserializeNBT(registries, tag.getCompoundOrEmpty("items"));
        this.pestleUsedCounter = tag.getShortOr("pestleUsed", (short)0);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putShort("pestleUsed", (short)this.pestleUsedCounter);
        compound.put("items", (Tag)this.items.serializeNBT(registries));
    }

    public NonNullList<ItemStack> getItemStacks() {
        return InventoryHelper.getItemStacks((IItemHandler)this.items);
    }

    public boolean usePestle(Level level) {
        int itemCount = 0;
        ArrayList<PotionIngredient> potionIngredients = new ArrayList<PotionIngredient>();
        for (ItemStack item : this.getItemStacks()) {
            if (item.isEmpty()) continue;
            ++itemCount;
            PotionHelper.getIngredient(item).ifPresent(potionIngredients::add);
        }
        if (itemCount > 1) {
            ++this.pestleUsedCounter;
            this.spawnPestleParticles(level);
        }
        return this.pestleUsedCounter >= 5 && this.createPotionEssence(potionIngredients, level);
    }

    private boolean createPotionEssence(List<PotionIngredient> potionIngredients, Level level) {
        PotionContents potionContents = PotionHelper.combineIngredients(potionIngredients);
        if (!potionContents.hasEffects()) {
            this.pestleUsedCounter = 0;
            for (int clearSlot = 0; clearSlot < this.items.getSlots(); ++clearSlot) {
                if (this.items.getStackInSlot(clearSlot).isEmpty()) continue;
                if (!level.isClientSide) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, this.items.getStackInSlot(clearSlot).copy());
                    level.addFreshEntity((Entity)itemEntity);
                }
                this.items.setStackInSlot(clearSlot, ItemStack.EMPTY);
            }
        } else {
            for (int clearSlot = 0; clearSlot < this.items.getSlots(); ++clearSlot) {
                this.items.setStackInSlot(clearSlot, ItemStack.EMPTY);
            }
            this.pestleUsedCounter = 0;
            this.finishCoolDown = level.getGameTime() + 20L;
            if (level.isClientSide) {
                return true;
            }
            ItemStack resultItem = new ItemStack((ItemLike)ModItems.POTION_ESSENCE.get());
            PotionHelper.addPotionContentsToStack(resultItem, potionContents);
            ItemEntity itemEntity = new ItemEntity(level, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, resultItem);
            level.addFreshEntity((Entity)itemEntity);
        }
        this.setChanged();
        return false;
    }

    private void spawnPestleParticles(Level level) {
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.15, (double)this.getBlockPos().getZ() + 0.5, 0.0, 0.1, 0.0);
    }

    public boolean isInCooldown(Level level) {
        return level.getGameTime() < this.finishCoolDown;
    }

    @Override
    public boolean getDataChanged() {
        boolean ret = this.dataChanged;
        this.dataChanged = false;
        return ret;
    }

    public IItemHandler getItems() {
        return this.items;
    }

    public void dropItems(Level level) {
        InventoryHelper.dropInventoryItems(level, this.worldPosition, (IItemHandler)this.items);
    }

    public int getPestleUsedCounter() {
        return this.pestleUsedCounter;
    }
}

