/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.color.item;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColorAnalyzer {
    private static final double MAX_MERGE_DISTANCE = 30.0;

    public static int[] filterInteriorPixels(int[] pixels, int width, int height) {
        int[] result = new int[pixels.length];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int idx = y * width + x;
                int argb = pixels[idx];
                int alpha = argb >> 24 & 0xFF;
                if (alpha < 32) continue;
                boolean touchesTransparent = false;
                block2: for (int dy = -1; dy <= 1 && !touchesTransparent; ++dy) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        int neighbor;
                        int neighborAlpha;
                        if (dx == 0 && dy == 0) continue;
                        int nx = x + dx;
                        int ny = y + dy;
                        if (nx < 0 || ny < 0 || nx >= width || ny >= height || (neighborAlpha = (neighbor = pixels[ny * width + nx]) >> 24 & 0xFF) >= 32) continue;
                        touchesTransparent = true;
                        continue block2;
                    }
                }
                if (touchesTransparent) continue;
                result[idx] = argb;
            }
        }
        return result;
    }

    public static List<Color> getMainAndAccentColors(int[] pixels, int width, int height) {
        pixels = ColorAnalyzer.filterInteriorPixels(pixels, width, height);
        HashMap<Integer, Integer> colorCounts = new HashMap<Integer, Integer>();
        for (int argb : pixels) {
            int alpha = argb >> 24 & 0xFF;
            if (alpha < 32) continue;
            int rgb = argb & 0xFFFFFF;
            colorCounts.merge(rgb, 1, Integer::sum);
        }
        ArrayList<ColorGroup> groups = new ArrayList<ColorGroup>();
        for (Map.Entry entry : colorCounts.entrySet()) {
            Color color = new Color((Integer)entry.getKey());
            boolean added = false;
            for (ColorGroup group : groups) {
                if (!(group.distanceTo(color) <= 30.0)) continue;
                group.add(color, (Integer)entry.getValue());
                added = true;
                break;
            }
            if (added) continue;
            groups.add(new ColorGroup(color, (Integer)entry.getValue()));
        }
        groups.sort((a, b) -> Integer.compare(b.totalWeight, a.totalWeight));
        ColorGroup mainGroup = (ColorGroup)groups.getFirst();
        Color mainColor = mainGroup.getRepresentativeColor();
        double weightExponent = 0.7;
        double distanceExponent = 1.3;
        ColorGroup accentGroup = mainGroup;
        double bestScore = -1.0;
        for (int i = 1; i < groups.size(); ++i) {
            ColorGroup group = (ColorGroup)groups.get(i);
            double distance = mainGroup.distanceTo(group);
            double score = Math.pow(group.totalWeight, weightExponent) * Math.pow(distance, distanceExponent);
            if (!(score > bestScore)) continue;
            bestScore = score;
            accentGroup = group;
        }
        Color accentColor = accentGroup.getRepresentativeColor();
        return List.of(mainColor, accentColor);
    }

    private static class ColorGroup {
        int rSum = 0;
        int gSum = 0;
        int bSum = 0;
        int totalWeight = 0;
        final List<Color> colors = new ArrayList<Color>();

        ColorGroup(Color color, int weight) {
            this.add(color, weight);
        }

        void add(Color color, int weight) {
            this.rSum += color.getRed() * weight;
            this.gSum += color.getGreen() * weight;
            this.bSum += color.getBlue() * weight;
            this.totalWeight += weight;
            this.colors.add(color);
        }

        Color getAverageColor() {
            if (this.totalWeight == 0) {
                return Color.BLACK;
            }
            return new Color(this.rSum / this.totalWeight, this.gSum / this.totalWeight, this.bSum / this.totalWeight);
        }

        Color getRepresentativeColor() {
            if (this.colors.isEmpty()) {
                return Color.BLACK;
            }
            Color avg = this.getAverageColor();
            double minDistance = Double.MAX_VALUE;
            Color best = this.colors.getFirst();
            for (Color c : this.colors) {
                double dist = ColorGroup.colorDistance(avg, c);
                if (!(dist < minDistance)) continue;
                minDistance = dist;
                best = c;
            }
            return best;
        }

        double distanceTo(ColorGroup other) {
            return ColorGroup.colorDistance(this.getAverageColor(), other.getAverageColor());
        }

        double distanceTo(Color color) {
            return ColorGroup.colorDistance(this.getAverageColor(), color);
        }

        private static double colorDistance(Color a, Color b) {
            int dr = a.getRed() - b.getRed();
            int dg = a.getGreen() - b.getGreen();
            int db = a.getBlue() - b.getBlue();
            return Math.sqrt(dr * dr + dg * dg + db * db);
        }
    }
}

