/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import reliquary.block.ApothecaryMortarBlock;
import reliquary.block.tile.ApothecaryMortarBlockEntity;

public class ApothecaryMortarRenderer
implements BlockEntityRenderer<ApothecaryMortarBlockEntity> {
    public void render(ApothecaryMortarBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, Vec3 cameraPos) {
        Direction direction = (Direction)blockEntity.getBlockState().getValue(ApothecaryMortarBlock.FACING);
        float horizontalRotation = direction == Direction.UP ? 0.0f : (float)direction.get2DDataValue() * 90.0f;
        NonNullList<ItemStack> mortarItems = blockEntity.getItemStacks();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.3, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(horizontalRotation));
        this.renderMortarItem(poseStack, buffer, packedLight, () -> {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(40.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        }, (ItemStack)mortarItems.get(0), -0.09f, 0.0f, packedOverlay);
        this.renderMortarItem(poseStack, buffer, packedLight, () -> {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(40.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        }, (ItemStack)mortarItems.get(1), 0.0f, 0.09f, packedOverlay);
        this.renderMortarItem(poseStack, buffer, packedLight, () -> {
            poseStack.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(40.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
        }, (ItemStack)mortarItems.get(2), 0.09f, 0.0f, packedOverlay);
        poseStack.popPose();
    }

    private void renderMortarItem(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Runnable processRotationTransforms, ItemStack itemToRender, float translateX, float translateZ, int packedOverlay) {
        if (!itemToRender.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(translateX, 0.0f, translateZ);
            processRotationTransforms.run();
            poseStack.scale(0.6f, 0.6f, 0.6f);
            Minecraft.getInstance().getItemRenderer().renderStatic(itemToRender, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, buffer, null, 0);
            poseStack.popPose();
        }
    }
}

