/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import reliquary.block.tile.PedestalBlockEntity;
import reliquary.client.registry.PedestalClientRegistry;

public class PedestalRenderer
implements BlockEntityRenderer<PedestalBlockEntity> {
    public void render(PedestalBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, Vec3 cameraPos) {
        if (!blockEntity.getItem().isEmpty()) {
            ItemStack stack = blockEntity.getItem();
            poseStack.pushPose();
            float yDiff = Mth.sin((float)((float)(System.currentTimeMillis() % 86400000L) / 1000.0f)) * 0.1f + 0.1f;
            poseStack.translate(0.5, 0.9 + (double)yDiff, 0.5);
            float f3 = (float)(System.currentTimeMillis() % 86400000L) / 2000.0f * 57.295776f;
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f3));
            poseStack.scale(0.75f, 0.75f, 0.75f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, null, 0);
            poseStack.popPose();
            PedestalClientRegistry.getItemRenderer(stack).ifPresent(extraRenderer -> extraRenderer.doRender(blockEntity, partialTicks, poseStack, buffer, packedLight, packedOverlay));
        }
    }

    public AABB getRenderBoundingBox(PedestalBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        AABB aabb = new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
        blockEntity.executeOnActionItem(ai -> ai.getRenderBoundingBoxOuterPosition().ifPresent(arg_0 -> ((AABB)aabb).expandTowards(arg_0)));
        return aabb;
    }
}

