/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionfc;
import reliquary.entity.shot.ShotBase;

public class ShotRenderer<T extends ShotBase>
extends EntityRenderer<T, EntityRenderState> {
    private final ResourceLocation texture;

    public ShotRenderer(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context);
        this.texture = texture;
    }

    public void render(EntityRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(0.1f, 0.1f, 0.1f);
        poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer vertexBuilder = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.addVertex(vertexBuilder, pose, packedLight, -0.5f, -0.25f, 0, 1);
        this.addVertex(vertexBuilder, pose, packedLight, 0.5f, -0.25f, 1, 1);
        this.addVertex(vertexBuilder, pose, packedLight, 0.5f, 0.75f, 1, 0);
        this.addVertex(vertexBuilder, pose, packedLight, -0.5f, 0.75f, 0, 0);
        poseStack.popPose();
        super.render(renderState, poseStack, bufferSource, packedLight);
    }

    public EntityRenderState createRenderState() {
        return new EntityRenderState();
    }

    private void addVertex(VertexConsumer vertexBuilder, PoseStack.Pose pose, int packedLight, float x, float y, int u, int v) {
        vertexBuilder.addVertex(pose, x, y, 0.0f).setColor(255, 255, 255, 255).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

