/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jade.provider;

import java.text.SimpleDateFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import reliquary.Reliquary;
import reliquary.block.AlkahestryAltarBlock;
import reliquary.block.tile.AlkahestryAltarBlockEntity;
import reliquary.compat.jade.provider.JadeHelper;
import reliquary.reference.Config;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ITextElement;

public class DataProviderAltar
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    private static final ResourceLocation ALTAR_UID = Reliquary.getRL("altar");

    @Nullable
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        return super.getIcon((Accessor)accessor, config, currentIcon);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        BlockEntity blockEntity;
        if (Boolean.TRUE.equals(Config.CLIENT.wailaShiftForInfo.get()) && !accessor.getPlayer().isCrouching()) {
            tooltip.add((Component)Component.translatable((String)"waila.reliquary.shift_for_more").withStyle(ChatFormatting.ITALIC));
            return;
        }
        if (!(accessor.getBlock() instanceof AlkahestryAltarBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof AlkahestryAltarBlockEntity)) {
            return;
        }
        AlkahestryAltarBlockEntity altar = (AlkahestryAltarBlockEntity)blockEntity;
        IElementHelper helper = IElementHelper.get();
        if (!altar.isActive()) {
            tooltip.add((Component)Component.translatable((String)"waila.reliquary.altar.inactive").withStyle(ChatFormatting.RED));
            Vec2 delta = new Vec2(0.0f, -4.0f);
            IElement redstoneIcon = helper.item(Items.REDSTONE.getDefaultInstance(), JadeHelper.ITEM_ICON_SCALE);
            ITextElement requirementText = helper.text((Component)Component.literal((String)String.format("%d / %d", altar.getRedstoneCount(), Config.COMMON.blocks.altar.redstoneCost.get())));
            redstoneIcon.size(redstoneIcon.getSize().add(delta)).translate(delta);
            requirementText.size(requirementText.getSize().add(delta)).translate(delta.add(new Vec2(0.0f, (redstoneIcon.getSize().y - requirementText.getSize().y) / 2.0f)));
            tooltip.add(List.of(redstoneIcon, requirementText));
            return;
        }
        tooltip.add((Component)Component.translatable((String)"waila.reliquary.altar.active").withStyle(ChatFormatting.GREEN));
        int cycleTime = accessor.getServerData().getIntOr("cycleTime", 0);
        tooltip.add((Component)Component.translatable((String)"waila.reliquary.altar.time_remaining", (Object[])new Object[]{new SimpleDateFormat("mm:ss").format(cycleTime * 50)}));
    }

    public ResourceLocation getUid() {
        return ALTAR_UID;
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        AlkahestryAltarBlockEntity altar = (AlkahestryAltarBlockEntity)blockAccessor.getBlockEntity();
        compoundTag.putInt("cycleTime", altar.getCycleTime());
    }
}

