/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jade.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import reliquary.Reliquary;
import reliquary.block.ApothecaryCauldronBlock;
import reliquary.block.tile.ApothecaryCauldronBlockEntity;
import reliquary.compat.jade.provider.CachedBodyDataProvider;
import reliquary.compat.jade.provider.JadeHelper;
import reliquary.util.TooltipBuilder;
import reliquary.util.potions.PotionHelper;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;

public class DataProviderCauldron
extends CachedBodyDataProvider {
    @Override
    public List<List<IElement>> getWailaBodyToCache(IElementHelper helper, BlockAccessor accessor, IPluginConfig config) {
        ItemStack stack;
        BlockEntity blockEntity;
        ArrayList<List<IElement>> lines = new ArrayList<List<IElement>>();
        if (!(accessor.getBlock() instanceof ApothecaryCauldronBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof ApothecaryCauldronBlockEntity)) {
            return List.of();
        }
        ApothecaryCauldronBlockEntity cauldron = (ApothecaryCauldronBlockEntity)blockEntity;
        if (!cauldron.getPotionContents().hasEffects()) {
            return List.of();
        }
        ArrayList<IElement> ingredientHints = new ArrayList<IElement>();
        if (!cauldron.hasNetherwart()) {
            ingredientHints.add(helper.item(Items.NETHER_WART.getDefaultInstance(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.MISSING));
        } else {
            ingredientHints.add(helper.item(Items.NETHER_WART.getDefaultInstance(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.SATISFIED));
        }
        if (cauldron.hasDragonBreath()) {
            if (!cauldron.hasGunpowder()) {
                ingredientHints.add(helper.item(Items.GUNPOWDER.getDefaultInstance(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.MISSING));
            } else {
                ingredientHints.add(helper.item(Items.GUNPOWDER.getDefaultInstance(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.SATISFIED));
            }
            ingredientHints.add(helper.item(Items.DRAGON_BREATH.getDefaultInstance(), JadeHelper.ITEM_ICON_SCALE, JadeHelper.SATISFIED));
        }
        lines.add(ingredientHints);
        ArrayList<IElement> ingredients1 = new ArrayList<IElement>();
        if (cauldron.getRedstoneCount() > 0) {
            stack = new ItemStack((ItemLike)Items.REDSTONE, cauldron.getRedstoneCount());
            ingredients1.add(helper.item(stack));
        }
        if (cauldron.getGlowstoneCount() > 0) {
            stack = new ItemStack((ItemLike)Items.GLOWSTONE_DUST, cauldron.getGlowstoneCount());
            ingredients1.add(helper.item(stack));
        }
        lines.add(ingredients1);
        FluidStack fluidPlaceHolder = new FluidStack((Fluid)Fluids.WATER, 1000 * cauldron.getLiquidLevel() / 3);
        MutableComponent potionType = cauldron.hasDragonBreath() ? Component.translatable((String)"waila.reliquary.cauldron.lingering") : (cauldron.hasGunpowder() ? Component.translatable((String)"waila.reliquary.cauldron.splash") : Component.translatable((String)"waila.reliquary.cauldron.potion"));
        lines.add(DataProviderCauldron.createTank(helper, fluidPlaceHolder, 1000, (Component)potionType));
        ArrayList components = new ArrayList();
        TooltipBuilder.of(components::add, Item.TooltipContext.of((Level)cauldron.getLevel())).potionEffects(PotionHelper.augmentPotionContents(cauldron.getPotionContents(), cauldron.getRedstoneCount(), cauldron.getGlowstoneCount()));
        lines.add(components.stream().map(arg_0 -> ((IElementHelper)helper).text(arg_0)).collect(Collectors.toList()));
        return lines;
    }

    public static List<IElement> createTank(IElementHelper helper, FluidStack fluidStack, int capacity, Component displayName) {
        MutableComponent text;
        if (displayName == FormattedText.EMPTY) {
            displayName = fluidStack.getHoverName();
        }
        if (capacity <= 0) {
            return List.of();
        }
        if (fluidStack.isEmpty()) {
            text = Component.translatable((String)"jade.fluid.empty");
        } else {
            String amountText = IDisplayHelper.get().humanReadableNumber((double)fluidStack.getAmount(), "B", true);
            text = Component.translatable((String)"jade.fluid", (Object[])new Object[]{displayName, amountText});
        }
        ProgressStyle progressStyle = helper.progressStyle();
        progressStyle.overlay(helper.fluid(JadeFluidObject.of((Fluid)fluidStack.getFluid())));
        IElement tank = helper.progress((float)fluidStack.getAmount() / (float)capacity, (Component)text, progressStyle, BoxStyle.getNestedBox(), false);
        return List.of(tank);
    }

    public ResourceLocation getUid() {
        return Reliquary.getRL("cauldron");
    }
}

