/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import reliquary.Reliquary;
import reliquary.compat.jei.ComponentSubtypeInterpreter;
import reliquary.compat.jei.ItemDescriptionBuilder;
import reliquary.compat.jei.MobCharmRecipeMaker;
import reliquary.compat.jei.SpawnEggRecipeMaker;
import reliquary.compat.jei.alkahestry.AlkahestryChargingRecipeCategory;
import reliquary.compat.jei.alkahestry.AlkahestryCraftingRecipeCategory;
import reliquary.compat.jei.cauldron.CauldronRecipeCategory;
import reliquary.compat.jei.cauldron.CauldronRecipeMaker;
import reliquary.compat.jei.infernaltear.InfernalTearRecipeCategory;
import reliquary.compat.jei.infernaltear.InfernalTearRecipeMaker;
import reliquary.compat.jei.lingering.ArrowShotRecipeMaker;
import reliquary.compat.jei.magazines.MagazineRecipeMaker;
import reliquary.compat.jei.mortar.MortarRecipeCategory;
import reliquary.compat.jei.mortar.MortarRecipeMaker;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModBlocks;
import reliquary.init.ModDataComponents;
import reliquary.init.ModItems;
import reliquary.reference.Config;

@JeiPlugin
public class ReliquaryPlugin
implements IModPlugin {
    private static final String EFFECTS_TAG = "effects";

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        this.registerNbtSubtypeInterpreter(registration, ModItems.MOB_CHARM_FRAGMENT.get(), ModDataComponents.ENTITY_NAME.get());
        this.registerNbtSubtypeInterpreter(registration, ModItems.MOB_CHARM.get(), ModDataComponents.ENTITY_NAME.get());
        if (Boolean.FALSE.equals(Config.COMMON.disable.disablePotions.get())) {
            this.registerNbtSubtypeInterpreter(registration, ModItems.POTION_ESSENCE.get(), DataComponents.POTION_CONTENTS);
            this.registerNbtSubtypeInterpreter(registration, ModItems.POTION.get(), DataComponents.POTION_CONTENTS);
            this.registerNbtSubtypeInterpreter(registration, ModItems.SPLASH_POTION.get(), DataComponents.POTION_CONTENTS);
            this.registerNbtSubtypeInterpreter(registration, ModItems.LINGERING_POTION.get(), DataComponents.POTION_CONTENTS);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.TIPPED_ARROW.get(), DataComponents.POTION_CONTENTS);
            this.registerNbtSubtypeInterpreter(registration, ModItems.NEUTRAL_BULLET.get(), DataComponents.POTION_CONTENTS);
            this.registerNbtSubtypeInterpreter(registration, ModItems.NEUTRAL_MAGAZINE.get(), DataComponents.POTION_CONTENTS);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        if (Boolean.FALSE.equals(Config.COMMON.disable.disableAlkahestry.get())) {
            registration.addRecipeCategories(new IRecipeCategory[]{new AlkahestryCraftingRecipeCategory(guiHelper)});
            registration.addRecipeCategories(new IRecipeCategory[]{new AlkahestryChargingRecipeCategory(guiHelper)});
        }
        if (Boolean.FALSE.equals(Config.COMMON.disable.disablePotions.get())) {
            registration.addRecipeCategories(new IRecipeCategory[]{new MortarRecipeCategory(guiHelper)});
            registration.addRecipeCategories(new IRecipeCategory[]{new CauldronRecipeCategory(guiHelper)});
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new InfernalTearRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(AlkahestryChargingRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)Blocks.CRAFTING_TABLE)});
        registration.addCraftingStation(AlkahestryCraftingRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)Blocks.CRAFTING_TABLE)});
        registration.addCraftingStation(MortarRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)ModBlocks.APOTHECARY_MORTAR.get())});
        registration.addCraftingStation(CauldronRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)ModBlocks.APOTHECARY_CAULDRON.get())});
        registration.addCraftingStation(InfernalTearRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)ModItems.INFERNAL_TEAR.get())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        if (Boolean.FALSE.equals(Config.COMMON.disable.disableAlkahestry.get())) {
            registration.addRecipes(AlkahestryCraftingRecipeCategory.TYPE, AlkahestryRecipeRegistry.getCraftingRecipes());
            registration.addRecipes(AlkahestryChargingRecipeCategory.TYPE, AlkahestryRecipeRegistry.getChargingRecipes());
        }
        if (Boolean.FALSE.equals(Config.COMMON.disable.disablePotions.get())) {
            registration.addRecipes(MortarRecipeCategory.TYPE, MortarRecipeMaker.getRecipes());
            registration.addRecipes(CauldronRecipeCategory.TYPE, CauldronRecipeMaker.getRecipes());
            registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, ArrowShotRecipeMaker.getRecipes(jeiHelpers, (Item)ModItems.TIPPED_ARROW.get(), Items.ARROW, 0.125f, "arrow"));
            registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, ArrowShotRecipeMaker.getRecipes(jeiHelpers, ModItems.NEUTRAL_BULLET.get(), "bullet"));
        }
        if (Boolean.FALSE.equals(Config.COMMON.disable.disableHandgun.get())) {
            registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, MagazineRecipeMaker.getRecipes(jeiHelpers));
        }
        if (Boolean.FALSE.equals(Config.COMMON.disable.disableCharms.get())) {
            registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, MobCharmRecipeMaker.getRecipes());
            this.registerMobCharmBeltRecipe(registration);
        }
        if (Boolean.FALSE.equals(Config.COMMON.disable.disableSpawnEggRecipes.get())) {
            registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, SpawnEggRecipeMaker.getRecipes());
        }
        registration.addRecipes(InfernalTearRecipeCategory.TYPE, InfernalTearRecipeMaker.getRecipes());
        ItemDescriptionBuilder.addIngredientInfo(registration);
    }

    private void registerMobCharmBeltRecipe(IRecipeRegistration registration) {
        NonNullList fragments = NonNullList.create();
        ModItems.MOB_CHARM_FRAGMENT.get().addCreativeTabItems(arg_0 -> ReliquaryPlugin.lambda$registerMobCharmBeltRecipe$0((List)fragments, arg_0));
        SlotDisplay.Composite fragmentSlotDisplay = new SlotDisplay.Composite((List)fragments);
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getJeiHelpers().getVanillaRecipeFactory();
        CraftingRecipe recipe = vanillaRecipeFactory.createShapedRecipeBuilder(CraftingBookCategory.MISC, (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(new ItemStack((ItemLike)ModItems.MOB_CHARM_BELT.get()))).group("reliquary.mob_charm").define(Character.valueOf('l'), Ingredient.of((HolderSet)RegistryUtil.getRegistry((ResourceKey)Registries.ITEM).getOrThrow(Tags.Items.LEATHERS))).define(Character.valueOf('f'), Ingredient.of((ItemLike)((ItemLike)ModItems.MOB_CHARM_FRAGMENT.get())), (SlotDisplay)fragmentSlotDisplay).pattern("lll").pattern("f f").pattern("fff").build();
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, Collections.singletonList(new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Reliquary.getRL("items/mob_charm_belt")), (Recipe)recipe)));
    }

    private void registerNbtSubtypeInterpreter(ISubtypeRegistration registration, Item item, DataComponentType<?> component) {
        registration.registerSubtypeInterpreter(item, (ISubtypeInterpreter)new ComponentSubtypeInterpreter(component));
    }

    public ResourceLocation getPluginUid() {
        return Reliquary.getRL("default");
    }

    private static /* synthetic */ void lambda$registerMobCharmBeltRecipe$0(List fragments, ItemStack stack) {
        fragments.add(new SlotDisplay.ItemStackSlotDisplay(stack));
    }
}

