/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.infernaltear;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import reliquary.Reliquary;
import reliquary.compat.jei.infernaltear.InfernalTearRecipe;
import reliquary.init.ModItems;
import reliquary.item.InfernalTearItem;
import reliquary.util.XpHelper;

public class InfernalTearRecipeCategory
extends AbstractRecipeCategory<InfernalTearRecipe> {
    public static final IRecipeType<InfernalTearRecipe> TYPE = IRecipeType.create((String)"reliquary", (String)"infernal_tear", InfernalTearRecipe.class);
    private static final ResourceLocation BACKGROUNDS_TEXTURE = Reliquary.getRL("textures/gui/jei/backgrounds.png");
    private final IDrawable background;

    private static IDrawable getIcon(IGuiHelper guiHelper) {
        ItemStack iconTear = new ItemStack((ItemLike)ModItems.INFERNAL_TEAR.get());
        InfernalTearItem.setTearTarget(iconTear, new ItemStack((ItemLike)Items.IRON_INGOT));
        return guiHelper.createDrawableItemStack(iconTear);
    }

    public InfernalTearRecipeCategory(IGuiHelper guiHelper) {
        super(TYPE, (Component)Component.translatable((String)"jei.reliquary.recipe.infernal_tear"), InfernalTearRecipeCategory.getIcon(guiHelper), 110, 25);
        this.background = guiHelper.createDrawable(BACKGROUNDS_TEXTURE, 0, 76, 110, 25);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InfernalTearRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 0).add(recipe.getInput());
    }

    public void draw(InfernalTearRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        int experiencePoints = recipe.getExperiencePoints();
        String points = experiencePoints + " " + Language.getInstance().getOrDefault("jei.reliquary.recipe.infernal_tear.xp");
        Font fontRenderer = Minecraft.getInstance().font;
        int stringWidth = fontRenderer.width(points);
        guiGraphics.drawString(fontRenderer, points, (int)((double)this.background.getWidth() / 2.0 + ((double)this.background.getWidth() / 2.0 + 16.0 - (double)stringWidth) / 2.0), 5, 8453920);
        this.drawLevels(guiGraphics, experiencePoints, fontRenderer);
    }

    private void drawLevels(GuiGraphics guiGraphics, int experiencePoints, Font fontRenderer) {
        int numberOfLevels = XpHelper.getLevelForExperience(experiencePoints);
        this.drawXpBar(guiGraphics, experiencePoints, numberOfLevels);
        this.drawXpLevel(guiGraphics, fontRenderer, numberOfLevels);
    }

    private void drawXpLevel(GuiGraphics guiGraphics, Font fontRenderer, int numberOfLevels) {
        String xpLevel = Integer.toString(numberOfLevels);
        int x = (this.background.getWidth() - fontRenderer.width(xpLevel)) / 2;
        int y = this.background.getHeight() - 10;
        guiGraphics.drawString(fontRenderer, xpLevel, x + 1, y, 0);
        guiGraphics.drawString(fontRenderer, xpLevel, x - 1, y, 0);
        guiGraphics.drawString(fontRenderer, xpLevel, x, y + 1, 0);
        guiGraphics.drawString(fontRenderer, xpLevel, x, y - 1, 0);
        guiGraphics.drawString(fontRenderer, xpLevel, x, y, 8453920);
    }

    private void drawXpBar(GuiGraphics guiGraphics, int experiencePoints, int level) {
        int partialXp = experiencePoints - XpHelper.getExperienceForLevel(level);
        int maxBarExperience = XpHelper.getExperienceLimitOnLevel(level);
        if (partialXp == 0) {
            return;
        }
        float minU = 0.0f;
        float minV = 101.0f;
        float maxU = 110.0f * ((float)partialXp / (float)maxBarExperience);
        float maxV = 106.0f;
        int width = (int)(maxU - minU);
        int height = (int)(maxV - minV);
        int x = 0;
        int y = this.background.getHeight() - 5;
        guiGraphics.blit(RenderType::guiTextured, BACKGROUNDS_TEXTURE, x, y, minU, minV, width, height, 256, 256);
    }
}

