/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import reliquary.init.ModItems;
import reliquary.item.util.IPotionItem;
import reliquary.util.potions.PotionHelper;

public class PotionEffectsRecipe
implements CraftingRecipe {
    private final ShapedRecipePattern pattern;
    private final ItemStack result;
    private final String group;
    private final float potionDurationFactor;

    public PotionEffectsRecipe(String group, ShapedRecipePattern pattern, ItemStack result, float potionDurationFactor) {
        this.group = group;
        this.pattern = pattern;
        this.result = result;
        this.potionDurationFactor = potionDurationFactor;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack newOutput = this.result.copy();
        this.findMatchAndUpdatePotionContents(inv).ifPresent(potionContents -> PotionHelper.addPotionContentsToStack(newOutput, potionContents));
        return newOutput;
    }

    private Optional<PotionContents> findMatchAndUpdatePotionContents(CraftingInput inv) {
        for (int startX = 0; startX <= inv.width() - this.pattern.width(); ++startX) {
            for (int startY = 0; startY <= inv.width() - this.pattern.height(); ++startY) {
                Optional<PotionContents> ret = this.checkMatchAndUpdatePotionContents(inv, startX, startY, false);
                if (ret.isPresent()) {
                    return ret;
                }
                ret = this.checkMatchAndUpdatePotionContents(inv, startX, startY, true);
                if (!ret.isPresent()) continue;
                return ret;
            }
        }
        return Optional.empty();
    }

    private Optional<PotionContents> checkMatchAndUpdatePotionContents(CraftingInput inv, int startX, int startY, boolean mirror) {
        PotionContents targetPotionContents = PotionContents.EMPTY;
        for (int x = 0; x < this.pattern.width(); ++x) {
            for (int y = 0; y < this.pattern.height(); ++y) {
                int subX = x - startX;
                int subY = y - startY;
                ItemStack stack = inv.getItem(x + y * inv.width());
                if (!this.testIngredient(subX, subY, mirror, stack)) {
                    return Optional.empty();
                }
                targetPotionContents = (PotionContents)this.updateTargetEffects(stack, targetPotionContents).getB();
            }
        }
        return Optional.of(targetPotionContents);
    }

    private boolean testIngredient(int subX, int subY, boolean mirror, ItemStack stack) {
        if (subX >= 0 && subY >= 0 && subX < this.pattern.width() && subY < this.pattern.height()) {
            if (mirror) {
                return ((Optional)this.pattern.ingredients().get(this.pattern.width() - subX - 1 + subY * this.pattern.width())).map(i -> i.test(stack)).orElse(stack.isEmpty());
            }
            return ((Optional)this.pattern.ingredients().get(subX + subY * this.pattern.width())).map(i -> i.test(stack)).orElse(stack.isEmpty());
        }
        return false;
    }

    public boolean matches(CraftingInput inv, Level level) {
        return this.pattern.matches(inv);
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.createFromOptionals((List)this.pattern.ingredients());
    }

    private Tuple<Boolean, PotionContents> updateTargetEffects(ItemStack stack, PotionContents targetPotionContents) {
        Item item = stack.getItem();
        if (item instanceof IPotionItem) {
            IPotionItem potionItem = (IPotionItem)item;
            PotionContents potionContents = potionItem.getPotionContents(stack);
            if (!potionContents.hasEffects()) {
                return new Tuple((Object)true, (Object)targetPotionContents);
            }
            if (!targetPotionContents.hasEffects()) {
                targetPotionContents = PotionHelper.changePotionEffectsDuration(potionContents, this.potionDurationFactor);
            } else {
                return new Tuple((Object)PotionHelper.changePotionEffectsDuration(potionContents, this.potionDurationFactor).equals((Object)targetPotionContents), (Object)targetPotionContents);
            }
        }
        return new Tuple((Object)true, (Object)targetPotionContents);
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<? extends CraftingRecipe> getSerializer() {
        return ModItems.POTION_EFFECTS_SERIALIZER.get();
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public ShapedRecipePattern getPattern() {
        return this.pattern;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public float getPotionDurationFactor() {
        return this.potionDurationFactor;
    }

    public static class Serializer
    implements RecipeSerializer<PotionEffectsRecipe> {
        private static final MapCodec<PotionEffectsRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.FLOAT.fieldOf("duration_factor").forGetter(recipe -> Float.valueOf(recipe.potionDurationFactor))).apply((Applicative)instance, PotionEffectsRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, PotionEffectsRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Recipe::group, (StreamCodec)ShapedRecipePattern.STREAM_CODEC, PotionEffectsRecipe::getPattern, (StreamCodec)ItemStack.STREAM_CODEC, PotionEffectsRecipe::getResult, (StreamCodec)ByteBufCodecs.FLOAT, PotionEffectsRecipe::getPotionDurationFactor, PotionEffectsRecipe::new);

        public MapCodec<PotionEffectsRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PotionEffectsRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

