/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting.alkahestry;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import reliquary.Reliquary;
import reliquary.crafting.AlkahestryChargingRecipe;
import reliquary.crafting.conditions.AlkahestryEnabledCondition;

public class ChargingRecipeBuilder {
    private final Ingredient ingredient;
    private final int charge;

    private ChargingRecipeBuilder(ItemLike ingredient, int charge) {
        this.ingredient = Ingredient.of((ItemLike)ingredient);
        this.charge = charge;
    }

    public static ChargingRecipeBuilder chargingRecipe(ItemLike result, int charge) {
        return new ChargingRecipeBuilder(result, charge);
    }

    public void build(RecipeOutput recipeOutput, ResourceLocation id) {
        ResourceKey fullId = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Reliquary.getRL("alkahestry/charging/" + id.getPath()));
        recipeOutput.withConditions(new ICondition[]{new AlkahestryEnabledCondition()}).accept(fullId, (Recipe)new AlkahestryChargingRecipe(this.ingredient, this.charge), null);
    }
}

