/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import reliquary.Reliquary;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;

public class ChestLootInjectSubProvider
implements LootTableSubProvider {
    protected static final Map<ResourceKey<LootTable>, ResourceKey<LootTable>> LOOT_INJECTS = new HashMap<ResourceKey<LootTable>, ResourceKey<LootTable>>();
    private static final String INJECT_FOLDER = "inject/";
    public static final ResourceKey<LootTable> ABANDONED_MINESHAFT = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT);
    public static final ResourceKey<LootTable> DESERT_PYRAMID = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID);
    public static final ResourceKey<LootTable> END_CITY_TREASURE = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.END_CITY_TREASURE);
    public static final ResourceKey<LootTable> IGLOO_CHEST = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.IGLOO_CHEST);
    public static final ResourceKey<LootTable> JUNGLE_TEMPLE = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.JUNGLE_TEMPLE);
    public static final ResourceKey<LootTable> NETHER_BRIDGE = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE);
    public static final ResourceKey<LootTable> SIMPLE_DUNGEON = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON);
    public static final ResourceKey<LootTable> STRONGHOLD_CORRIDOR = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CORRIDOR);
    public static final ResourceKey<LootTable> STRONGHOLD_CROSSING = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CROSSING);
    public static final ResourceKey<LootTable> STRONGHOLD_LIBRARY = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_LIBRARY);
    public static final ResourceKey<LootTable> VILLAGE_WEAPONSMITH = ChestLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_WEAPONSMITH);

    private static ResourceKey<LootTable> createInjectLootTableRegistryKey(ResourceKey<LootTable> vanillaLootTable) {
        ResourceLocation location = Reliquary.getRL(INJECT_FOLDER + vanillaLootTable.location().getPath());
        ResourceKey injectLootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)location);
        LOOT_INJECTS.put(vanillaLootTable, (ResourceKey<LootTable>)injectLootTable);
        return injectLootTable;
    }

    public ChestLootInjectSubProvider(HolderLookup.Provider registries) {
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> tables) {
        tables.accept(ABANDONED_MINESHAFT, ChestLootInjectSubProvider.getLootTable(61, this.getItemLootEntry(ModItems.RIB_BONE.get(), 10, 2), this.getItemLootEntry(ModItems.SLIME_PEARL.get(), 8, 3), this.getItemLootEntry(ModItems.BAT_WING.get(), 8, 3), this.getItemLootEntry(ModItems.NEBULOUS_HEART.get(), 4, 2), this.getItemLootEntry(ModItems.SQUID_BEAK.get(), 8, 4), this.getItemLootEntry(ModItems.WITCH_HAT.get(), 5, 2), this.getItemLootEntry(ModItems.ANGELIC_FEATHER.get(), 2)));
        tables.accept(DESERT_PYRAMID, ChestLootInjectSubProvider.getLootTable(44, this.getItemLootEntry(ModItems.RIB_BONE.get(), 10, 3), this.getItemLootEntry(ModItems.CHELICERAE.get(), 10, 2), this.getItemLootEntry(ModItems.CATALYZING_GLAND.get(), 8, 4), this.getItemLootEntry(ModItems.ZOMBIE_HEART.get(), 8, 5), this.getItemLootEntry(ModItems.NEBULOUS_HEART.get(), 5, 3), this.getItemLootEntry(ModItems.MOLTEN_CORE.get(), 5, 2), this.getItemLootEntry(ModItems.SQUID_BEAK.get(), 8, 4), this.getItemLootEntry(ModItems.ANGELIC_FEATHER.get(), 2)));
        tables.accept(END_CITY_TREASURE, ChestLootInjectSubProvider.getLootTable(64, this.getItemLootEntry(ModItems.NEBULOUS_HEART.get(), 30, 5), this.getItemLootEntry(ModItems.ENDER_STAFF.get(), 5), this.getItemLootEntry(ModItems.RENDING_GALE.get(), 1)));
        tables.accept(IGLOO_CHEST, ChestLootInjectSubProvider.getLootTable(60, this.getItemLootEntry(ModItems.FROZEN_CORE.get(), 40, 5)));
        tables.accept(JUNGLE_TEMPLE, ChestLootInjectSubProvider.getLootTable(62, this.getItemLootEntry(ModItems.RIB_BONE.get(), 10, 3), this.getItemLootEntry(ModItems.CATALYZING_GLAND.get(), 7, 3), this.getItemLootEntry(ModItems.BAT_WING.get(), 7, 3), this.getItemLootEntry(ModItems.NEBULOUS_HEART.get(), 6, 3), this.getItemLootEntry(ModItems.ANGELIC_FEATHER.get(), 2)));
        tables.accept(NETHER_BRIDGE, ChestLootInjectSubProvider.getLootTable(61, this.getItemLootEntry(ModItems.WITHERED_RIB.get(), 20, 2), this.getItemLootEntry(ModItems.SLIME_PEARL.get(), 8), this.getItemLootEntry(ModItems.MOLTEN_CORE.get(), 8, 2), this.getItemLootEntry(ModItems.VOID_TEAR.get(), 1), this.getItemLootEntry(ModItems.SALAMANDER_EYE.get(), 1), this.getItemLootEntry((Item)ModBlocks.INTERDICTION_TORCH_ITEM.get(), 1)));
        tables.accept(SIMPLE_DUNGEON, ChestLootInjectSubProvider.getLootTable(68, this.getItemLootEntry(ModItems.RIB_BONE.get(), 8, 2), this.getItemLootEntry(ModItems.CHELICERAE.get(), 8, 2), this.getItemLootEntry(ModItems.ZOMBIE_HEART.get(), 8, 2), this.getItemLootEntry(ModItems.WITCH_HAT.get(), 3, 2), this.getItemLootEntry(ModItems.GLOWING_WATER.get(), 5, 2)));
        tables.accept(STRONGHOLD_CORRIDOR, ChestLootInjectSubProvider.getLootTable(64, this.getItemLootEntry(ModItems.RIB_BONE.get(), 7, 3), this.getItemLootEntry(ModItems.SLIME_PEARL.get(), 8, 4), this.getItemLootEntry(ModItems.NEBULOUS_HEART.get(), 8, 4), this.getItemLootEntry(ModItems.FROZEN_CORE.get(), 7, 4), this.getItemLootEntry(ModItems.ANGELHEART_VIAL.get(), 4, 2), this.getItemLootEntry((Item)ModItems.SHEARS_OF_WINTER.get(), 2)));
        tables.accept(STRONGHOLD_CROSSING, ChestLootInjectSubProvider.getLootTable(55, this.getItemLootEntry(ModItems.RIB_BONE.get(), 7, 3), this.getItemLootEntry(ModItems.WITHERED_RIB.get(), 5, 3), this.getItemLootEntry(ModItems.SLIME_PEARL.get(), 9, 3), this.getItemLootEntry(ModItems.NEBULOUS_HEART.get(), 9, 3), this.getItemLootEntry(ModItems.FROZEN_CORE.get(), 7, 3), this.getItemLootEntry(ModItems.ANGELHEART_VIAL.get(), 8, 4)));
        tables.accept(STRONGHOLD_LIBRARY, ChestLootInjectSubProvider.getLootTable(92, this.getItemLootEntry(ModItems.SLIME_PEARL.get(), 8, 4)));
        tables.accept(VILLAGE_WEAPONSMITH, ChestLootInjectSubProvider.getLootTable(78, this.getItemLootEntry(ModItems.ZOMBIE_HEART.get(), 10, 5), this.getItemLootEntry(ModItems.WITCH_HAT.get(), 5, 2), this.getItemLootEntry(ModItems.GLOWING_WATER.get(), 7, 4)));
    }

    private LootPoolEntryContainer.Builder<?> getItemLootEntry(Item item, int weight, int maxCount) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)maxCount)));
    }

    private LootPoolEntryContainer.Builder<?> getItemLootEntry(Item item, int weight) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight);
    }

    private static LootTable.Builder getLootTable(int emptyWeight, LootPoolEntryContainer.Builder<?> ... entries) {
        LootPool.Builder pool = LootPool.lootPool().name("main");
        for (LootPoolEntryContainer.Builder<?> entry : entries) {
            pool.add(entry);
        }
        pool.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(emptyWeight));
        return LootTable.lootTable().withPool(pool);
    }
}

